/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.swirlds.platform.gui.GuiUtils;
import com.swirlds.platform.gui.hashgraph.HashgraphPictureOptions;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class HashgraphGuiControls
implements HashgraphPictureOptions {
    private final Checkbox freezeCheckbox = new Checkbox("Freeze: don't change this window");
    private final Checkbox simpleColorsCheckbox;
    private final Checkbox expandCheckbox;
    private final Checkbox labelRoundCheckbox;
    private final Checkbox labelVoteCheckbox;
    private final Checkbox labelEventHashCheckbox;
    private final Checkbox labelRoundRecCheckbox;
    private final Checkbox labelConsOrderCheckbox;
    private final Checkbox labelConsTimestampCheckbox;
    private final Checkbox labelNGenCheckbox;
    private final Checkbox labelBirthroundCheckbox;
    private final Checkbox labelBranchNumberCheckbox;
    private final Checkbox labelDeGenCheckbox;
    private final Checkbox displayLatestEvents;
    private final Component[] comps;
    private final JSpinner numGenerations;
    private final JSpinner startGeneration;

    public HashgraphGuiControls(ItemListener freezeListener) {
        this.freezeCheckbox.addItemListener(freezeListener);
        this.simpleColorsCheckbox = new Checkbox("Colors: blue=consensus, green=not");
        this.expandCheckbox = new Checkbox("Expand: wider so lines don't cross");
        this.labelRoundCheckbox = new Checkbox("Labels: Round created");
        this.labelVoteCheckbox = new Checkbox("Labels: Vote");
        this.labelEventHashCheckbox = new Checkbox("Labels: Event Hash (h)");
        this.labelRoundRecCheckbox = new Checkbox("Labels: Round received (consensus)");
        this.labelConsOrderCheckbox = new Checkbox("Labels: Order (consensus)");
        this.labelConsTimestampCheckbox = new Checkbox("Labels: Timestamp (consensus)");
        this.labelNGenCheckbox = new Checkbox("Labels: NGen (non-deterministic generation)");
        this.labelBirthroundCheckbox = new Checkbox("Labels: Birth round");
        this.labelBranchNumberCheckbox = new Checkbox("Labels: Branch number");
        this.labelDeGenCheckbox = new Checkbox("Labels: DeGen");
        this.displayLatestEvents = new Checkbox("Display latest events");
        this.displayLatestEvents.setState(true);
        this.numGenerations = new JSpinner(new SpinnerNumberModel((Number)25, Integer.valueOf(5), Integer.valueOf(1000), (Number)1));
        ((JSpinner.DefaultEditor)this.numGenerations.getEditor()).getTextField().setColumns(10);
        this.startGeneration = new JSpinner(new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), (Number)1L));
        ((JSpinner.DefaultEditor)this.startGeneration.getEditor()).getTextField().setColumns(10);
        this.startGeneration.setEnabled(false);
        this.displayLatestEvents.addItemListener(e -> {
            switch (e.getStateChange()) {
                case 1: {
                    this.startGeneration.setEnabled(false);
                    break;
                }
                case 2: {
                    this.startGeneration.setEnabled(true);
                }
            }
        });
        this.comps = new Component[]{this.freezeCheckbox, this.simpleColorsCheckbox, this.expandCheckbox, this.labelRoundCheckbox, this.labelVoteCheckbox, this.labelEventHashCheckbox, this.labelRoundRecCheckbox, this.labelConsOrderCheckbox, this.labelConsTimestampCheckbox, this.labelNGenCheckbox, this.labelBirthroundCheckbox, this.labelBranchNumberCheckbox, this.labelDeGenCheckbox, this.displayLatestEvents};
    }

    public void setExpanded(boolean expand) {
        this.expandCheckbox.setState(expand);
    }

    public JPanel createPanel() {
        JPanel checkboxesPanel = new JPanel();
        checkboxesPanel.setLayout(new GridBagLayout());
        checkboxesPanel.setBackground(Color.WHITE);
        checkboxesPanel.setVisible(true);
        GridBagConstraints constr = new GridBagConstraints();
        constr.fill = 0;
        constr.anchor = 23;
        constr.weightx = 0.0;
        constr.weighty = 0.0;
        constr.gridx = 0;
        constr.gridy = 0;
        constr.insets = new Insets(0, 10, -4, 0);
        constr.gridheight = 1;
        constr.gridwidth = -1;
        for (Component c : this.comps) {
            checkboxesPanel.add(c, constr);
            constr.gridwidth = 0;
            ++constr.gridy;
        }
        checkboxesPanel.add((Component)new Label(" "), constr);
        constr.gridx = 0;
        ++constr.gridy;
        constr.gridwidth = 0;
        checkboxesPanel.add((Component)new Label("NOTE: when typing in values below, hit enter to apply the value"), constr);
        constr.gridx = 0;
        ++constr.gridy;
        constr.gridwidth = 1;
        checkboxesPanel.add((Component)new Label(" "), constr);
        constr.gridx = 0;
        ++constr.gridy;
        constr.gridwidth = 1;
        checkboxesPanel.add((Component)new Label("Display "), constr);
        ++constr.gridx;
        checkboxesPanel.add((Component)this.numGenerations, constr);
        ++constr.gridx;
        constr.gridwidth = -1;
        checkboxesPanel.add((Component)new Label(" generations"), constr);
        ++constr.gridx;
        constr.gridwidth = 0;
        checkboxesPanel.add((Component)new Label(""), constr);
        constr.gridx = 0;
        ++constr.gridy;
        constr.gridwidth = 1;
        checkboxesPanel.add((Component)new Label("Start generation "), constr);
        ++constr.gridx;
        checkboxesPanel.add((Component)this.startGeneration, constr);
        ++constr.gridx;
        constr.gridwidth = 0;
        checkboxesPanel.add((Component)new Label(""), constr);
        constr.gridx = 0;
        ++constr.gridy;
        checkboxesPanel.add((Component)new Label(" "), constr);
        ++constr.gridy;
        checkboxesPanel.add((Component)GuiUtils.newJTextArea(GuiUtils.wrap(50, "- Witnesses are colored circles, non-witnesses are black/gray \n- Dark circles are part of the consensus, light are not \n- Judges are blue \n- Non-famous witnesses are yellow \n- Famous witnesses are green \n- Undecided witnesses are red \n- The selected event is magenta with green border \n- The parents of the selected event have magenta borders \n- The events the selected event can strongly see are cyan ")), constr);
        ++constr.gridy;
        constr.weighty = 1.0;
        checkboxesPanel.add((Component)new Label(" "), constr);
        return checkboxesPanel;
    }

    @Override
    public boolean isPictureFrozen() {
        return this.freezeCheckbox.getState();
    }

    @Override
    public boolean isExpanded() {
        return this.expandCheckbox.getState();
    }

    @Override
    public boolean writeRoundCreated() {
        return this.labelRoundCheckbox.getState();
    }

    @Override
    public boolean writeVote() {
        return this.labelVoteCheckbox.getState();
    }

    @Override
    public boolean writeEventHash() {
        return this.labelEventHashCheckbox.getState();
    }

    @Override
    public boolean writeRoundReceived() {
        return this.labelRoundRecCheckbox.getState();
    }

    @Override
    public boolean writeConsensusOrder() {
        return this.labelConsOrderCheckbox.getState();
    }

    @Override
    public boolean writeConsensusTimeStamp() {
        return this.labelConsTimestampCheckbox.getState();
    }

    @Override
    public boolean writeNGen() {
        return this.labelNGenCheckbox.getState();
    }

    @Override
    public boolean writeBirthRound() {
        return this.labelBirthroundCheckbox.getState();
    }

    @Override
    public boolean writeDeGen() {
        return this.labelDeGenCheckbox.getState();
    }

    @Override
    public boolean simpleColors() {
        return this.simpleColorsCheckbox.getState();
    }

    @Override
    public int getNumGenerationsDisplay() {
        Object object = this.numGenerations.getValue();
        if (object instanceof Integer) {
            Integer generations = (Integer)object;
            return generations;
        }
        return 25;
    }

    @Override
    public long getStartGeneration() {
        Object object = this.startGeneration.getValue();
        if (object instanceof Long) {
            Long generations = (Long)object;
            return generations;
        }
        return -1L;
    }

    @Override
    public boolean displayLatestEvents() {
        return this.displayLatestEvents.getState();
    }

    @Override
    public boolean writeBranches() {
        return this.labelBranchNumberCheckbox.getState();
    }

    @Override
    public void setStartGeneration(long startGeneration) {
        this.startGeneration.setValue(startGeneration);
    }
}

