/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.platform.state;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.hedera.hapi.platform.state.codec.ConsensusSnapshotJsonCodec;
import com.hedera.hapi.platform.state.codec.ConsensusSnapshotProtoCodec;
import com.hedera.hapi.platform.state.schema.ConsensusSnapshotSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class ConsensusSnapshot {
    public static final Codec<ConsensusSnapshot> PROTOBUF = new ConsensusSnapshotProtoCodec();
    public static final JsonCodec<ConsensusSnapshot> JSON = new ConsensusSnapshotJsonCodec();
    public static final ConsensusSnapshot DEFAULT = ConsensusSnapshot.newBuilder().build();
    private final long round;
    @NonNull
    private final List<Bytes> judgeHashes;
    @NonNull
    private final List<MinimumJudgeInfo> minimumJudgeInfoList;
    private final long nextConsensusNumber;
    @Nullable
    private final Timestamp consensusTimestamp;
    @NonNull
    private final List<JudgeId> judgeIds;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public ConsensusSnapshot(long round, List<Bytes> judgeHashes, List<MinimumJudgeInfo> minimumJudgeInfoList, long nextConsensusNumber, Timestamp consensusTimestamp, List<JudgeId> judgeIds) {
        this.$unknownFields = null;
        this.round = round;
        this.judgeHashes = judgeHashes != null ? judgeHashes : Collections.emptyList();
        this.minimumJudgeInfoList = minimumJudgeInfoList == null ? Collections.emptyList() : minimumJudgeInfoList;
        this.nextConsensusNumber = nextConsensusNumber;
        this.consensusTimestamp = consensusTimestamp;
        this.judgeIds = judgeIds == null ? Collections.emptyList() : judgeIds;
    }

    public ConsensusSnapshot(long round, List<Bytes> judgeHashes, List<MinimumJudgeInfo> minimumJudgeInfoList, long nextConsensusNumber, Timestamp consensusTimestamp, List<JudgeId> judgeIds, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.round = round;
        this.judgeHashes = judgeHashes != null ? judgeHashes : Collections.emptyList();
        this.minimumJudgeInfoList = minimumJudgeInfoList == null ? Collections.emptyList() : minimumJudgeInfoList;
        this.nextConsensusNumber = nextConsensusNumber;
        this.consensusTimestamp = consensusTimestamp;
        this.judgeIds = judgeIds == null ? Collections.emptyList() : judgeIds;
    }

    public long round() {
        return this.round;
    }

    public List<Bytes> judgeHashes() {
        return this.judgeHashes;
    }

    public List<MinimumJudgeInfo> minimumJudgeInfoList() {
        return this.minimumJudgeInfoList;
    }

    public long nextConsensusNumber() {
        return this.nextConsensusNumber;
    }

    public Timestamp consensusTimestamp() {
        return this.consensusTimestamp;
    }

    public List<JudgeId> judgeIds() {
        return this.judgeIds;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ConsensusSnapshotSchema.ROUND, (long)this.round, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytesList((FieldDefinition)ConsensusSnapshotSchema.JUDGE_HASHES, this.judgeHashes);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ConsensusSnapshotSchema.MINIMUM_JUDGE_INFO_LIST, this.minimumJudgeInfoList, MinimumJudgeInfo.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ConsensusSnapshotSchema.NEXT_CONSENSUS_NUMBER, (long)this.nextConsensusNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ConsensusSnapshotSchema.CONSENSUS_TIMESTAMP, (Object)this.consensusTimestamp, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ConsensusSnapshotSchema.JUDGE_IDS, this.judgeIds, JudgeId.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.$hashCode == -1) {
            List<JudgeId> list$judgeIds;
            List<MinimumJudgeInfo> list$minimumJudgeInfoList;
            List<Bytes> list$judgeHashes;
            int result = 1;
            if (this.round != ConsensusSnapshot.DEFAULT.round) {
                result = 31 * result + Long.hashCode(this.round);
            }
            if ((list$judgeHashes = this.judgeHashes) != null) {
                for (Bytes o : list$judgeHashes) {
                    if (o != null) {
                        result = 31 * result + o.hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if ((list$minimumJudgeInfoList = this.minimumJudgeInfoList) != null) {
                for (Object e : list$minimumJudgeInfoList) {
                    if (e != null) {
                        result = 31 * result + e.hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.nextConsensusNumber != ConsensusSnapshot.DEFAULT.nextConsensusNumber) {
                result = 31 * result + Long.hashCode(this.nextConsensusNumber);
            }
            if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(ConsensusSnapshot.DEFAULT.consensusTimestamp)) {
                result = 31 * result + this.consensusTimestamp.hashCode();
            }
            if ((list$judgeIds = this.judgeIds) != null) {
                for (JudgeId judgeId : list$judgeIds) {
                    if (judgeId != null) {
                        result = 31 * result + ((Object)judgeId).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.$unknownFields != null) {
                void var5_9;
                boolean bl = false;
                while (var5_9 < this.$unknownFields.size()) {
                    result = 31 * result + this.$unknownFields.get((int)var5_9).hashCode();
                    ++var5_9;
                }
            }
            long l = result;
            l += l << 30;
            l ^= l >>> 27;
            l += l << 16;
            l ^= l >>> 20;
            l += l << 5;
            l ^= l >>> 18;
            l += l << 10;
            l ^= l >>> 24;
            l += l << 30;
            this.$hashCode = (int)l;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ConsensusSnapshot thatObj = (ConsensusSnapshot)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.round != thatObj.round) {
            return false;
        }
        if (this.judgeHashes == null && thatObj.judgeHashes != null) {
            return false;
        }
        if (this.judgeHashes != null && !this.judgeHashes.equals(thatObj.judgeHashes)) {
            return false;
        }
        if (this.minimumJudgeInfoList == null && thatObj.minimumJudgeInfoList != null) {
            return false;
        }
        if (this.minimumJudgeInfoList != null && !this.minimumJudgeInfoList.equals(thatObj.minimumJudgeInfoList)) {
            return false;
        }
        if (this.nextConsensusNumber != thatObj.nextConsensusNumber) {
            return false;
        }
        if (this.consensusTimestamp == null && thatObj.consensusTimestamp != null) {
            return false;
        }
        if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(thatObj.consensusTimestamp)) {
            return false;
        }
        if (this.judgeIds == null && thatObj.judgeIds != null) {
            return false;
        }
        if (this.judgeIds != null && !this.judgeIds.equals(thatObj.judgeIds)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "ConsensusSnapshot[round=" + this.round + ", judgeHashes=" + String.valueOf(this.judgeHashes) + ", minimumJudgeInfoList=" + String.valueOf(this.minimumJudgeInfoList) + ", nextConsensusNumber=" + this.nextConsensusNumber + ", consensusTimestamp=" + String.valueOf(this.consensusTimestamp) + ", judgeIds=" + String.valueOf(this.judgeIds) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasConsensusTimestamp() {
        return this.consensusTimestamp != null;
    }

    public Timestamp consensusTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasConsensusTimestamp() ? this.consensusTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp consensusTimestampOrThrow() {
        return Objects.requireNonNull(this.consensusTimestamp, "Field consensusTimestamp is null");
    }

    public void ifConsensusTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasConsensusTimestamp()) {
            ifPresent.accept(this.consensusTimestamp);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.round, this.judgeHashes, this.minimumJudgeInfoList, this.nextConsensusNumber, this.consensusTimestamp, this.judgeIds, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long round = 0L;
        @NonNull
        private List<Bytes> judgeHashes = Collections.emptyList();
        @NonNull
        private List<MinimumJudgeInfo> minimumJudgeInfoList = Collections.emptyList();
        private long nextConsensusNumber = 0L;
        @Nullable
        private Timestamp consensusTimestamp = null;
        @NonNull
        private List<JudgeId> judgeIds = Collections.emptyList();
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long round, List<Bytes> judgeHashes, List<MinimumJudgeInfo> minimumJudgeInfoList, long nextConsensusNumber, Timestamp consensusTimestamp, List<JudgeId> judgeIds) {
            this.$unknownFields = null;
            this.round = round;
            this.judgeHashes = judgeHashes != null ? judgeHashes : Collections.emptyList();
            this.minimumJudgeInfoList = minimumJudgeInfoList == null ? Collections.emptyList() : minimumJudgeInfoList;
            this.nextConsensusNumber = nextConsensusNumber;
            this.consensusTimestamp = consensusTimestamp;
            this.judgeIds = judgeIds == null ? Collections.emptyList() : judgeIds;
        }

        public Builder(long round, List<Bytes> judgeHashes, List<MinimumJudgeInfo> minimumJudgeInfoList, long nextConsensusNumber, Timestamp consensusTimestamp, List<JudgeId> judgeIds, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.round = round;
            this.judgeHashes = judgeHashes != null ? judgeHashes : Collections.emptyList();
            this.minimumJudgeInfoList = minimumJudgeInfoList == null ? Collections.emptyList() : minimumJudgeInfoList;
            this.nextConsensusNumber = nextConsensusNumber;
            this.consensusTimestamp = consensusTimestamp;
            this.judgeIds = judgeIds == null ? Collections.emptyList() : judgeIds;
        }

        public ConsensusSnapshot build() {
            return new ConsensusSnapshot(this.round, this.judgeHashes, this.minimumJudgeInfoList, this.nextConsensusNumber, this.consensusTimestamp, this.judgeIds);
        }

        public Builder round(long round) {
            this.round = round;
            return this;
        }

        public Builder judgeHashes(@NonNull List<Bytes> judgeHashes) {
            this.judgeHashes = judgeHashes != null ? judgeHashes : Collections.emptyList();
            return this;
        }

        public Builder judgeHashes(Bytes ... values) {
            this.judgeHashes = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder minimumJudgeInfoList(@NonNull List<MinimumJudgeInfo> minimumJudgeInfoList) {
            this.minimumJudgeInfoList = minimumJudgeInfoList != null ? minimumJudgeInfoList : Collections.emptyList();
            return this;
        }

        public Builder minimumJudgeInfoList(MinimumJudgeInfo ... values) {
            this.minimumJudgeInfoList = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder nextConsensusNumber(long nextConsensusNumber) {
            this.nextConsensusNumber = nextConsensusNumber;
            return this;
        }

        public Builder consensusTimestamp(@Nullable Timestamp consensusTimestamp) {
            this.consensusTimestamp = consensusTimestamp;
            return this;
        }

        public Builder consensusTimestamp(Timestamp.Builder builder) {
            this.consensusTimestamp = builder.build();
            return this;
        }

        public Builder judgeIds(@NonNull List<JudgeId> judgeIds) {
            this.judgeIds = judgeIds != null ? judgeIds : Collections.emptyList();
            return this;
        }

        public Builder judgeIds(JudgeId ... values) {
            this.judgeIds = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }
    }
}

