/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.runners;

import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.mockito.Mockito;
import org.mockito.internal.junit.UnnecessaryStubbingsReporter;
import org.mockito.internal.runners.InternalRunner;
import org.mockito.internal.runners.util.FailureDetector;

public class StrictRunner
implements InternalRunner {
    private final Class<?> testClass;
    private final InternalRunner runner;
    private boolean testsSkipped;

    public StrictRunner(InternalRunner runner, Class<?> testClass) {
        this.runner = runner;
        this.testClass = testClass;
        this.testsSkipped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RunNotifier notifier) {
        UnnecessaryStubbingsReporter reporter = new UnnecessaryStubbingsReporter();
        FailureDetector listener = new FailureDetector();
        Mockito.framework().addListener(reporter);
        try {
            notifier.addListener((RunListener)listener);
            this.runner.run(notifier);
        }
        finally {
            Mockito.framework().removeListener(reporter);
        }
        if (!this.testsSkipped && listener.isSuccessful()) {
            reporter.validateUnusedStubs(this.testClass, notifier);
        }
    }

    @Override
    public Description getDescription() {
        return this.runner.getDescription();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        RecordingFilter recordingFilter = new RecordingFilter(filter);
        this.runner.filter(recordingFilter);
    }

    private class RecordingFilter
    extends Filter {
        private final Filter delegate;

        public RecordingFilter(Filter delegate) {
            this.delegate = delegate;
        }

        public void apply(Object child) throws NoTestsRemainException {
            this.delegate.apply(child);
        }

        public Filter intersect(Filter second) {
            return this.delegate.intersect(second);
        }

        public boolean shouldRun(Description description) {
            boolean result = this.delegate.shouldRun(description);
            if (!result) {
                StrictRunner.this.testsSkipped = true;
            }
            return result;
        }

        public String describe() {
            return this.delegate.describe();
        }
    }
}

