/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.platform.state;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.codec.PlatformStateJsonCodec;
import com.hedera.hapi.platform.state.codec.PlatformStateProtoCodec;
import com.hedera.hapi.platform.state.schema.PlatformStateSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class PlatformState {
    public static final Codec<PlatformState> PROTOBUF = new PlatformStateProtoCodec();
    public static final JsonCodec<PlatformState> JSON = new PlatformStateJsonCodec();
    public static final PlatformState DEFAULT = PlatformState.newBuilder().build();
    @Nullable
    private final SemanticVersion creationSoftwareVersion;
    private final int roundsNonAncient;
    @Nullable
    private final ConsensusSnapshot consensusSnapshot;
    @Nullable
    private final Timestamp freezeTime;
    @Nullable
    private final Timestamp lastFrozenTime;
    private final long latestFreezeRound;
    @NonNull
    private final Bytes legacyRunningEventHash;
    private final long lowestJudgeGenerationBeforeBirthRoundMode;
    private final long lastRoundBeforeBirthRoundMode;
    @Nullable
    private final SemanticVersion firstVersionInBirthRoundMode;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public PlatformState(SemanticVersion creationSoftwareVersion, int roundsNonAncient, ConsensusSnapshot consensusSnapshot, Timestamp freezeTime, Timestamp lastFrozenTime, long latestFreezeRound, Bytes legacyRunningEventHash, long lowestJudgeGenerationBeforeBirthRoundMode, long lastRoundBeforeBirthRoundMode, SemanticVersion firstVersionInBirthRoundMode) {
        this.$unknownFields = null;
        this.creationSoftwareVersion = creationSoftwareVersion;
        this.roundsNonAncient = roundsNonAncient;
        this.consensusSnapshot = consensusSnapshot;
        this.freezeTime = freezeTime;
        this.lastFrozenTime = lastFrozenTime;
        this.latestFreezeRound = latestFreezeRound;
        this.legacyRunningEventHash = legacyRunningEventHash != null ? legacyRunningEventHash : Bytes.EMPTY;
        this.lowestJudgeGenerationBeforeBirthRoundMode = lowestJudgeGenerationBeforeBirthRoundMode;
        this.lastRoundBeforeBirthRoundMode = lastRoundBeforeBirthRoundMode;
        this.firstVersionInBirthRoundMode = firstVersionInBirthRoundMode;
    }

    public PlatformState(SemanticVersion creationSoftwareVersion, int roundsNonAncient, ConsensusSnapshot consensusSnapshot, Timestamp freezeTime, Timestamp lastFrozenTime, long latestFreezeRound, Bytes legacyRunningEventHash, long lowestJudgeGenerationBeforeBirthRoundMode, long lastRoundBeforeBirthRoundMode, SemanticVersion firstVersionInBirthRoundMode, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.creationSoftwareVersion = creationSoftwareVersion;
        this.roundsNonAncient = roundsNonAncient;
        this.consensusSnapshot = consensusSnapshot;
        this.freezeTime = freezeTime;
        this.lastFrozenTime = lastFrozenTime;
        this.latestFreezeRound = latestFreezeRound;
        this.legacyRunningEventHash = legacyRunningEventHash != null ? legacyRunningEventHash : Bytes.EMPTY;
        this.lowestJudgeGenerationBeforeBirthRoundMode = lowestJudgeGenerationBeforeBirthRoundMode;
        this.lastRoundBeforeBirthRoundMode = lastRoundBeforeBirthRoundMode;
        this.firstVersionInBirthRoundMode = firstVersionInBirthRoundMode;
    }

    public SemanticVersion creationSoftwareVersion() {
        return this.creationSoftwareVersion;
    }

    public int roundsNonAncient() {
        return this.roundsNonAncient;
    }

    public ConsensusSnapshot consensusSnapshot() {
        return this.consensusSnapshot;
    }

    public Timestamp freezeTime() {
        return this.freezeTime;
    }

    public Timestamp lastFrozenTime() {
        return this.lastFrozenTime;
    }

    public long latestFreezeRound() {
        return this.latestFreezeRound;
    }

    public Bytes legacyRunningEventHash() {
        return this.legacyRunningEventHash;
    }

    public long lowestJudgeGenerationBeforeBirthRoundMode() {
        return this.lowestJudgeGenerationBeforeBirthRoundMode;
    }

    public long lastRoundBeforeBirthRoundMode() {
        return this.lastRoundBeforeBirthRoundMode;
    }

    public SemanticVersion firstVersionInBirthRoundMode() {
        return this.firstVersionInBirthRoundMode;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PlatformStateSchema.CREATION_SOFTWARE_VERSION, (Object)this.creationSoftwareVersion, SemanticVersion.PROTOBUF);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)PlatformStateSchema.ROUNDS_NON_ANCIENT, (int)this.roundsNonAncient, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PlatformStateSchema.CONSENSUS_SNAPSHOT, (Object)this.consensusSnapshot, ConsensusSnapshot.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PlatformStateSchema.FREEZE_TIME, (Object)this.freezeTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PlatformStateSchema.LAST_FROZEN_TIME, (Object)this.lastFrozenTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PlatformStateSchema.LATEST_FREEZE_ROUND, (long)this.latestFreezeRound, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)PlatformStateSchema.LEGACY_RUNNING_EVENT_HASH, (RandomAccessData)this.legacyRunningEventHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PlatformStateSchema.LOWEST_JUDGE_GENERATION_BEFORE_BIRTH_ROUND_MODE, (long)this.lowestJudgeGenerationBeforeBirthRoundMode, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PlatformStateSchema.LAST_ROUND_BEFORE_BIRTH_ROUND_MODE, (long)this.lastRoundBeforeBirthRoundMode, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PlatformStateSchema.FIRST_VERSION_IN_BIRTH_ROUND_MODE, (Object)this.firstVersionInBirthRoundMode, SemanticVersion.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.creationSoftwareVersion != null && !this.creationSoftwareVersion.equals(PlatformState.DEFAULT.creationSoftwareVersion)) {
                result = 31 * result + this.creationSoftwareVersion.hashCode();
            }
            if (this.roundsNonAncient != PlatformState.DEFAULT.roundsNonAncient) {
                result = 31 * result + Integer.hashCode(this.roundsNonAncient);
            }
            if (this.consensusSnapshot != null && !this.consensusSnapshot.equals(PlatformState.DEFAULT.consensusSnapshot)) {
                result = 31 * result + this.consensusSnapshot.hashCode();
            }
            if (this.freezeTime != null && !this.freezeTime.equals(PlatformState.DEFAULT.freezeTime)) {
                result = 31 * result + this.freezeTime.hashCode();
            }
            if (this.lastFrozenTime != null && !this.lastFrozenTime.equals(PlatformState.DEFAULT.lastFrozenTime)) {
                result = 31 * result + this.lastFrozenTime.hashCode();
            }
            if (this.latestFreezeRound != PlatformState.DEFAULT.latestFreezeRound) {
                result = 31 * result + Long.hashCode(this.latestFreezeRound);
            }
            if (this.legacyRunningEventHash != null && !this.legacyRunningEventHash.equals((Object)PlatformState.DEFAULT.legacyRunningEventHash)) {
                result = 31 * result + this.legacyRunningEventHash.hashCode();
            }
            if (this.lowestJudgeGenerationBeforeBirthRoundMode != PlatformState.DEFAULT.lowestJudgeGenerationBeforeBirthRoundMode) {
                result = 31 * result + Long.hashCode(this.lowestJudgeGenerationBeforeBirthRoundMode);
            }
            if (this.lastRoundBeforeBirthRoundMode != PlatformState.DEFAULT.lastRoundBeforeBirthRoundMode) {
                result = 31 * result + Long.hashCode(this.lastRoundBeforeBirthRoundMode);
            }
            if (this.firstVersionInBirthRoundMode != null && !this.firstVersionInBirthRoundMode.equals(PlatformState.DEFAULT.firstVersionInBirthRoundMode)) {
                result = 31 * result + this.firstVersionInBirthRoundMode.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        PlatformState thatObj = (PlatformState)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.creationSoftwareVersion == null && thatObj.creationSoftwareVersion != null) {
            return false;
        }
        if (this.creationSoftwareVersion != null && !this.creationSoftwareVersion.equals(thatObj.creationSoftwareVersion)) {
            return false;
        }
        if (this.roundsNonAncient != thatObj.roundsNonAncient) {
            return false;
        }
        if (this.consensusSnapshot == null && thatObj.consensusSnapshot != null) {
            return false;
        }
        if (this.consensusSnapshot != null && !this.consensusSnapshot.equals(thatObj.consensusSnapshot)) {
            return false;
        }
        if (this.freezeTime == null && thatObj.freezeTime != null) {
            return false;
        }
        if (this.freezeTime != null && !this.freezeTime.equals(thatObj.freezeTime)) {
            return false;
        }
        if (this.lastFrozenTime == null && thatObj.lastFrozenTime != null) {
            return false;
        }
        if (this.lastFrozenTime != null && !this.lastFrozenTime.equals(thatObj.lastFrozenTime)) {
            return false;
        }
        if (this.latestFreezeRound != thatObj.latestFreezeRound) {
            return false;
        }
        if (this.legacyRunningEventHash == null && thatObj.legacyRunningEventHash != null) {
            return false;
        }
        if (this.legacyRunningEventHash != null && !this.legacyRunningEventHash.equals((Object)thatObj.legacyRunningEventHash)) {
            return false;
        }
        if (this.lowestJudgeGenerationBeforeBirthRoundMode != thatObj.lowestJudgeGenerationBeforeBirthRoundMode) {
            return false;
        }
        if (this.lastRoundBeforeBirthRoundMode != thatObj.lastRoundBeforeBirthRoundMode) {
            return false;
        }
        if (this.firstVersionInBirthRoundMode == null && thatObj.firstVersionInBirthRoundMode != null) {
            return false;
        }
        if (this.firstVersionInBirthRoundMode != null && !this.firstVersionInBirthRoundMode.equals(thatObj.firstVersionInBirthRoundMode)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "PlatformState[creationSoftwareVersion=" + String.valueOf(this.creationSoftwareVersion) + ", roundsNonAncient=" + this.roundsNonAncient + ", consensusSnapshot=" + String.valueOf(this.consensusSnapshot) + ", freezeTime=" + String.valueOf(this.freezeTime) + ", lastFrozenTime=" + String.valueOf(this.lastFrozenTime) + ", latestFreezeRound=" + this.latestFreezeRound + ", legacyRunningEventHash=" + String.valueOf(this.legacyRunningEventHash) + ", lowestJudgeGenerationBeforeBirthRoundMode=" + this.lowestJudgeGenerationBeforeBirthRoundMode + ", lastRoundBeforeBirthRoundMode=" + this.lastRoundBeforeBirthRoundMode + ", firstVersionInBirthRoundMode=" + String.valueOf(this.firstVersionInBirthRoundMode) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasCreationSoftwareVersion() {
        return this.creationSoftwareVersion != null;
    }

    public SemanticVersion creationSoftwareVersionOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasCreationSoftwareVersion() ? this.creationSoftwareVersion : defaultValue;
    }

    @NonNull
    public SemanticVersion creationSoftwareVersionOrThrow() {
        return Objects.requireNonNull(this.creationSoftwareVersion, "Field creationSoftwareVersion is null");
    }

    public void ifCreationSoftwareVersion(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasCreationSoftwareVersion()) {
            ifPresent.accept(this.creationSoftwareVersion);
        }
    }

    public boolean hasConsensusSnapshot() {
        return this.consensusSnapshot != null;
    }

    public ConsensusSnapshot consensusSnapshotOrElse(@NonNull ConsensusSnapshot defaultValue) {
        return this.hasConsensusSnapshot() ? this.consensusSnapshot : defaultValue;
    }

    @NonNull
    public ConsensusSnapshot consensusSnapshotOrThrow() {
        return Objects.requireNonNull(this.consensusSnapshot, "Field consensusSnapshot is null");
    }

    public void ifConsensusSnapshot(@NonNull Consumer<ConsensusSnapshot> ifPresent) {
        if (this.hasConsensusSnapshot()) {
            ifPresent.accept(this.consensusSnapshot);
        }
    }

    public boolean hasFreezeTime() {
        return this.freezeTime != null;
    }

    public Timestamp freezeTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasFreezeTime() ? this.freezeTime : defaultValue;
    }

    @NonNull
    public Timestamp freezeTimeOrThrow() {
        return Objects.requireNonNull(this.freezeTime, "Field freezeTime is null");
    }

    public void ifFreezeTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasFreezeTime()) {
            ifPresent.accept(this.freezeTime);
        }
    }

    public boolean hasLastFrozenTime() {
        return this.lastFrozenTime != null;
    }

    public Timestamp lastFrozenTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasLastFrozenTime() ? this.lastFrozenTime : defaultValue;
    }

    @NonNull
    public Timestamp lastFrozenTimeOrThrow() {
        return Objects.requireNonNull(this.lastFrozenTime, "Field lastFrozenTime is null");
    }

    public void ifLastFrozenTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasLastFrozenTime()) {
            ifPresent.accept(this.lastFrozenTime);
        }
    }

    public boolean hasFirstVersionInBirthRoundMode() {
        return this.firstVersionInBirthRoundMode != null;
    }

    public SemanticVersion firstVersionInBirthRoundModeOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasFirstVersionInBirthRoundMode() ? this.firstVersionInBirthRoundMode : defaultValue;
    }

    @NonNull
    public SemanticVersion firstVersionInBirthRoundModeOrThrow() {
        return Objects.requireNonNull(this.firstVersionInBirthRoundMode, "Field firstVersionInBirthRoundMode is null");
    }

    public void ifFirstVersionInBirthRoundMode(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasFirstVersionInBirthRoundMode()) {
            ifPresent.accept(this.firstVersionInBirthRoundMode);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.creationSoftwareVersion, this.roundsNonAncient, this.consensusSnapshot, this.freezeTime, this.lastFrozenTime, this.latestFreezeRound, this.legacyRunningEventHash, this.lowestJudgeGenerationBeforeBirthRoundMode, this.lastRoundBeforeBirthRoundMode, this.firstVersionInBirthRoundMode, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private SemanticVersion creationSoftwareVersion = null;
        private int roundsNonAncient = 0;
        @Nullable
        private ConsensusSnapshot consensusSnapshot = null;
        @Nullable
        private Timestamp freezeTime = null;
        @Nullable
        private Timestamp lastFrozenTime = null;
        private long latestFreezeRound = 0L;
        @NonNull
        private Bytes legacyRunningEventHash = Bytes.EMPTY;
        private long lowestJudgeGenerationBeforeBirthRoundMode = 0L;
        private long lastRoundBeforeBirthRoundMode = 0L;
        @Nullable
        private SemanticVersion firstVersionInBirthRoundMode = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(SemanticVersion creationSoftwareVersion, int roundsNonAncient, ConsensusSnapshot consensusSnapshot, Timestamp freezeTime, Timestamp lastFrozenTime, long latestFreezeRound, Bytes legacyRunningEventHash, long lowestJudgeGenerationBeforeBirthRoundMode, long lastRoundBeforeBirthRoundMode, SemanticVersion firstVersionInBirthRoundMode) {
            this.$unknownFields = null;
            this.creationSoftwareVersion = creationSoftwareVersion;
            this.roundsNonAncient = roundsNonAncient;
            this.consensusSnapshot = consensusSnapshot;
            this.freezeTime = freezeTime;
            this.lastFrozenTime = lastFrozenTime;
            this.latestFreezeRound = latestFreezeRound;
            this.legacyRunningEventHash = legacyRunningEventHash != null ? legacyRunningEventHash : Bytes.EMPTY;
            this.lowestJudgeGenerationBeforeBirthRoundMode = lowestJudgeGenerationBeforeBirthRoundMode;
            this.lastRoundBeforeBirthRoundMode = lastRoundBeforeBirthRoundMode;
            this.firstVersionInBirthRoundMode = firstVersionInBirthRoundMode;
        }

        public Builder(SemanticVersion creationSoftwareVersion, int roundsNonAncient, ConsensusSnapshot consensusSnapshot, Timestamp freezeTime, Timestamp lastFrozenTime, long latestFreezeRound, Bytes legacyRunningEventHash, long lowestJudgeGenerationBeforeBirthRoundMode, long lastRoundBeforeBirthRoundMode, SemanticVersion firstVersionInBirthRoundMode, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.creationSoftwareVersion = creationSoftwareVersion;
            this.roundsNonAncient = roundsNonAncient;
            this.consensusSnapshot = consensusSnapshot;
            this.freezeTime = freezeTime;
            this.lastFrozenTime = lastFrozenTime;
            this.latestFreezeRound = latestFreezeRound;
            this.legacyRunningEventHash = legacyRunningEventHash != null ? legacyRunningEventHash : Bytes.EMPTY;
            this.lowestJudgeGenerationBeforeBirthRoundMode = lowestJudgeGenerationBeforeBirthRoundMode;
            this.lastRoundBeforeBirthRoundMode = lastRoundBeforeBirthRoundMode;
            this.firstVersionInBirthRoundMode = firstVersionInBirthRoundMode;
        }

        public PlatformState build() {
            return new PlatformState(this.creationSoftwareVersion, this.roundsNonAncient, this.consensusSnapshot, this.freezeTime, this.lastFrozenTime, this.latestFreezeRound, this.legacyRunningEventHash, this.lowestJudgeGenerationBeforeBirthRoundMode, this.lastRoundBeforeBirthRoundMode, this.firstVersionInBirthRoundMode);
        }

        public Builder creationSoftwareVersion(@Nullable SemanticVersion creationSoftwareVersion) {
            this.creationSoftwareVersion = creationSoftwareVersion;
            return this;
        }

        public Builder creationSoftwareVersion(SemanticVersion.Builder builder) {
            this.creationSoftwareVersion = builder.build();
            return this;
        }

        public Builder roundsNonAncient(int roundsNonAncient) {
            this.roundsNonAncient = roundsNonAncient;
            return this;
        }

        public Builder consensusSnapshot(@Nullable ConsensusSnapshot consensusSnapshot) {
            this.consensusSnapshot = consensusSnapshot;
            return this;
        }

        public Builder consensusSnapshot(ConsensusSnapshot.Builder builder) {
            this.consensusSnapshot = builder.build();
            return this;
        }

        public Builder freezeTime(@Nullable Timestamp freezeTime) {
            this.freezeTime = freezeTime;
            return this;
        }

        public Builder freezeTime(Timestamp.Builder builder) {
            this.freezeTime = builder.build();
            return this;
        }

        public Builder lastFrozenTime(@Nullable Timestamp lastFrozenTime) {
            this.lastFrozenTime = lastFrozenTime;
            return this;
        }

        public Builder lastFrozenTime(Timestamp.Builder builder) {
            this.lastFrozenTime = builder.build();
            return this;
        }

        public Builder latestFreezeRound(long latestFreezeRound) {
            this.latestFreezeRound = latestFreezeRound;
            return this;
        }

        public Builder legacyRunningEventHash(@NonNull Bytes legacyRunningEventHash) {
            this.legacyRunningEventHash = legacyRunningEventHash != null ? legacyRunningEventHash : Bytes.EMPTY;
            return this;
        }

        public Builder lowestJudgeGenerationBeforeBirthRoundMode(long lowestJudgeGenerationBeforeBirthRoundMode) {
            this.lowestJudgeGenerationBeforeBirthRoundMode = lowestJudgeGenerationBeforeBirthRoundMode;
            return this;
        }

        public Builder lastRoundBeforeBirthRoundMode(long lastRoundBeforeBirthRoundMode) {
            this.lastRoundBeforeBirthRoundMode = lastRoundBeforeBirthRoundMode;
            return this;
        }

        public Builder firstVersionInBirthRoundMode(@Nullable SemanticVersion firstVersionInBirthRoundMode) {
            this.firstVersionInBirthRoundMode = firstVersionInBirthRoundMode;
            return this;
        }

        public Builder firstVersionInBirthRoundMode(SemanticVersion.Builder builder) {
            this.firstVersionInBirthRoundMode = builder.build();
            return this;
        }
    }
}

