/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.Pair;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.notification.Listener;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.common.utility.StopWatch;
import com.swirlds.demo.merkle.map.FCMConfig;
import com.swirlds.demo.merkle.map.MapValueData;
import com.swirlds.demo.merkle.map.MapValueFCQ;
import com.swirlds.demo.merkle.map.internal.ExpectedMapUtils;
import com.swirlds.demo.platform.AppClient;
import com.swirlds.demo.platform.ControlAction;
import com.swirlds.demo.platform.FCMQueryController;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PayloadCfgSimple;
import com.swirlds.demo.platform.PayloadConfig;
import com.swirlds.demo.platform.PlatformConfig;
import com.swirlds.demo.platform.PlatformTestingToolConsensusStateEventHandler;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.ProgressCfg;
import com.swirlds.demo.platform.PttTransactionPool;
import com.swirlds.demo.platform.SubmitConfig;
import com.swirlds.demo.platform.SuperConfig;
import com.swirlds.demo.platform.SyntheticBottleneckConfig;
import com.swirlds.demo.platform.TransactionCounter;
import com.swirlds.demo.platform.TransactionSubmitter;
import com.swirlds.demo.platform.Triple;
import com.swirlds.demo.platform.UnsafeMutablePTTStateAccessor;
import com.swirlds.demo.platform.fs.stresstest.proto.ControlType;
import com.swirlds.demo.platform.fs.stresstest.proto.StateSignatureTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransactionWrapper;
import com.swirlds.demo.platform.nft.NftQueryController;
import com.swirlds.demo.virtualmerkle.config.VirtualMerkleConfig;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapKey;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapKey;
import com.swirlds.demo.virtualmerkle.state.VirtualMerkleStateInitializer;
import com.swirlds.demo.virtualmerkle.transaction.handler.VirtualMerkleTransactionHandler;
import com.swirlds.fcqueue.FCQueue;
import com.swirlds.fcqueue.FCQueueStatistics;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ApplicationFinishedPayload;
import com.swirlds.logging.legacy.payload.CreateTransactionFailedPayload;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.SaveExpectedMapHandler;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.merkle.test.fixtures.map.pta.TransactionRecord;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.Browser;
import com.swirlds.platform.ParameterProvider;
import com.swirlds.platform.listeners.PlatformStatusChangeListener;
import com.swirlds.platform.listeners.PlatformStatusChangeNotification;
import com.swirlds.platform.listeners.ReconnectCompleteListener;
import com.swirlds.platform.listeners.ReconnectCompleteNotification;
import com.swirlds.platform.listeners.StateWriteToDiskCompleteListener;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import com.swirlds.platform.system.state.notifications.NewSignedStateListener;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.concurrent.interrupt.Uninterruptable;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.base.constructable.NoArgsConstructor;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.roster.RosterUtils;

public class PlatformTestingToolMain
implements SwirldMain<PlatformTestingToolState> {
    private static final Logger logger = LogManager.getLogger(PlatformTestingToolMain.class);
    private static final Marker LOGM_DEMO_INFO = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker LOGM_STARTUP = MarkerManager.getMarker((String)"STARTUP");
    private static final Marker LOGM_SUBMIT_DETAIL = MarkerManager.getMarker((String)"SUBMIT_DETAIL");
    private static final Marker LOGM_DEMO_QUORUM = MarkerManager.getMarker((String)"DEMO_QUORUM");
    private static final String FREEZE_TRANSACTION_TYPE = "freeze";
    private static final String FCM_CATEGORY = "FCM";
    private static final String VM_CATEGORY = "VM";
    boolean saveExpectedMapAtFreeze = false;
    Triple<byte[], PAYLOAD_TYPE, MapKey> submittedPayloadTriple = null;
    private static final int MILLIS_TO_SEC = 1000;
    int CHECK_IDLE_MILLISECONDS = 10000;
    boolean noMoreTransaction = false;
    private boolean allowRunSubmit = false;
    private boolean enableCheck = true;
    private boolean waitForSaveStateDuringFreeze = false;
    public AtomicBoolean handledExitValidation = new AtomicBoolean(false);
    private boolean queryRecord = false;
    private TransactionSubmitter submitter;
    private static final Counter.Config TRANSACTION_SUBMITTED_CONFIG;
    private Counter transactionSubmitted;
    private boolean checkedThisIdleInterval = false;
    private final PlatformConfig config;
    private NodeId selfId;
    private Platform platform;
    private volatile boolean isActive = false;
    private static final int CLIENT_AMOUNT = 2;
    AppClient[] appClient = new AppClient[2];
    private PttTransactionPool pttTransactionPool;
    private SubmitConfig submitConfig;
    private PayloadConfig payloadConfig;
    private SuperConfig currentConfig;
    private long totalFCMTransactions;
    private long prevFCMCreateAmount;
    private long prevFCMUpdateAmount;
    private long prevFCMTransferAmount;
    private long prevFCMDeleteAmount;
    private long prevVMCreateAmount;
    private long prevVMUpdateAmount;
    private long prevVMDeleteAmount;
    private long prevContractCreateAmount;
    private long prevContractExecutionAmount;
    private static final String PTT_COMPONENT = "PTT";
    private static final String ENTER_VALIDATION_THREAD_NAME = "enter-validator";
    private static final String EXIT_VALIDATION_THREAD_NAME = "exit-validator";
    private static final SpeedometerMetric.Config FCM_CREATE_SPEED_CONFIG;
    private SpeedometerMetric fcmCreateSpeed;
    private static final SpeedometerMetric.Config FCM_UPDATE_SPEED_CONFIG;
    private SpeedometerMetric fcmUpdateSpeed;
    private static final SpeedometerMetric.Config FCM_TRANSFER_SPEED_CONFIG;
    private SpeedometerMetric fcmTransferSpeed;
    private static final SpeedometerMetric.Config FCM_DELETE_SPEED_CONFIG;
    private SpeedometerMetric fcmDeleteSpeed;
    private static final SpeedometerMetric.Config VM_CREATE_SPEED_CONFIG;
    private SpeedometerMetric vmCreateSpeed;
    private static final SpeedometerMetric.Config VM_UPDATE_SPEED_CONFIG;
    private SpeedometerMetric vmUpdateSpeed;
    private static final SpeedometerMetric.Config VM_DELETE_SPEED_CONFIG;
    private SpeedometerMetric vmDeleteSpeed;
    private static final SpeedometerMetric.Config VM_CONTRACT_CREATE_SPEED_CONFIG;
    private SpeedometerMetric vmContractCreateSpeed;
    private static final SpeedometerMetric.Config VM_CONTRACT_EXECUTION_SPEED_CONFIG;
    private SpeedometerMetric vmContractExecutionSpeed;
    private static final SpeedometerMetric.Config TRAN_SUBMIT_TPS_SPEED_CONFIG;
    private SpeedometerMetric transactionSubmitSpeedometer;
    private FCMQueryController queryController;
    private NftQueryController nftQueryController;
    private static final double DEFAULT_HALF_LIFE = 10.0;
    private static final RunningAverageMetric.Config QUERY_LEAF_TIME_COST_MICRO_SEC_CONFIG;
    private RunningAverageMetric queryLeafTimeCostMicroSec;
    private static final SpeedometerMetric.Config QUERIES_ANSWERED_PER_SECOND_CONFIG;
    private SpeedometerMetric queriesAnsweredPerSecond;
    private static final RunningAverageMetric.Config EXPECTED_INVALID_SIG_RATIO_CONFIG;
    private RunningAverageMetric expectedInvalidSigRatio;
    private Instant previousTimestamp = null;
    private long queriesSentPerSec = -1L;
    private static final SemanticVersion semanticVersion;
    final PlatformTestingToolConsensusStateEventHandler consensusStateEventHandler;

    public PlatformTestingToolMain() {
        this.config = PlatformConfig.getDefault();
        this.consensusStateEventHandler = new PlatformTestingToolConsensusStateEventHandler(new PlatformStateFacade());
    }

    public static void main(String[] args) {
        Browser.parseCommandLineArgsAndLaunch((String[])args);
    }

    private void printJVMParameters() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = runtimeMXBean.getInputArguments();
        if (jvmArgs.size() == 0) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "No JVM ARGS!");
        }
        for (String arg : jvmArgs) {
            logger.info(LOGM_STARTUP, "JVM arg: {}", (Object)arg);
        }
    }

    private void sendFreezeTransaction() {
        Instant startTime = Instant.now().plus(1L, ChronoUnit.MINUTES);
        byte[] freezeBytes = this.pttTransactionPool.createFreezeTranByte(startTime);
        if (!this.submitter.sendFreezeTran(this.platform, freezeBytes)) {
            logger.warn(LogMarker.DEMO_INFO.getMarker(), (Object)new CreateTransactionFailedPayload(FREEZE_TRANSACTION_TYPE));
        }
    }

    private synchronized boolean subRoutine() {
        if (this.submittedPayloadTriple == null) {
            this.submittedPayloadTriple = this.pttTransactionPool.transaction();
        }
        if (this.submittedPayloadTriple != null) {
            logger.info(LOGM_SUBMIT_DETAIL, "is about to submit a {} transaction for {}", (Object)this.submittedPayloadTriple.middle(), (Object)this.submittedPayloadTriple.right());
            if (!this.isActive) {
                logger.info(LOGM_SUBMIT_DETAIL, "will not submit the transaction because isActive is false");
                return false;
            }
            boolean success = this.submitter.trySubmit(this.platform, (Pair<byte[], PAYLOAD_TYPE>)Pair.of((Object)this.submittedPayloadTriple.left(), (Object)((Object)this.submittedPayloadTriple.middle())));
            if (!success) {
                try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(this.platform.getSelfId());){
                    Thread.sleep(50L);
                    PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
                    ExpectedMapUtils.modifySubmitStatus(state, false, this.isActive, this.submittedPayloadTriple, this.payloadConfig);
                }
                catch (InterruptedException e) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "", (Throwable)e);
                }
                return false;
            }
            if (this.checkedThisIdleInterval) {
                this.checkedThisIdleInterval = false;
            }
            this.transactionSubmitted.increment();
            this.transactionSubmitSpeedometer.update(1.0);
            try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(this.platform.getSelfId());){
                PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
                ExpectedMapUtils.modifySubmitStatus(state, true, this.isActive, this.submittedPayloadTriple, this.payloadConfig);
            }
        }
        logger.info(LOGM_DEMO_INFO, "Stop generating transactions ");
        this.submitter.sendTransaction(this.platform, this.pttTransactionPool.createControlTranBytes(ControlType.ENTER_VALIDATION));
        logger.info(LOGM_DEMO_INFO, "node {} sent ENTER_VALIDATION Message", (Object)this.platform.getSelfId());
        this.noMoreTransaction = true;
        return false;
        this.submittedPayloadTriple = null;
        return true;
    }

    private void initAppStat() {
        Metrics metrics = this.platform.getContext().getMetrics();
        this.vmCreateSpeed = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)VM_CREATE_SPEED_CONFIG);
        this.vmUpdateSpeed = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)VM_UPDATE_SPEED_CONFIG);
        this.vmDeleteSpeed = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)VM_DELETE_SPEED_CONFIG);
        this.vmContractCreateSpeed = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)VM_CONTRACT_CREATE_SPEED_CONFIG);
        this.vmContractExecutionSpeed = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)VM_CONTRACT_EXECUTION_SPEED_CONFIG);
        this.fcmCreateSpeed = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)FCM_CREATE_SPEED_CONFIG);
        this.fcmUpdateSpeed = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)FCM_UPDATE_SPEED_CONFIG);
        this.fcmTransferSpeed = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)FCM_TRANSFER_SPEED_CONFIG);
        this.fcmDeleteSpeed = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)FCM_DELETE_SPEED_CONFIG);
        this.transactionSubmitted = (Counter)metrics.getOrCreate((MetricConfig)TRANSACTION_SUBMITTED_CONFIG);
        this.transactionSubmitSpeedometer = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)TRAN_SUBMIT_TPS_SPEED_CONFIG);
        this.queryLeafTimeCostMicroSec = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)QUERY_LEAF_TIME_COST_MICRO_SEC_CONFIG);
        this.queriesAnsweredPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)QUERIES_ANSWERED_PER_SECOND_CONFIG);
        this.expectedInvalidSigRatio = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)EXPECTED_INVALID_SIG_RATIO_CONFIG);
        FCQueueStatistics.register((Metrics)metrics);
        PlatformTestingToolConsensusStateEventHandler.initStatistics(this.platform);
        int SAMPLING_PERIOD = 5000;
        Timer statTimer = new Timer("stat timer" + String.valueOf(this.selfId), true);
        statTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(PlatformTestingToolMain.this.platform.getSelfId());){
                    PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
                    if (state != null) {
                        PlatformTestingToolMain.this.getCurrentTransactionStat(state);
                    }
                }
            }
        }, 0L, 5000L);
    }

    private long summation(List<TransactionCounter> counters, ValueExtractor valueExtractor) {
        long total = 0L;
        if (counters != null) {
            for (TransactionCounter counter : counters) {
                total += valueExtractor.getValue(counter);
            }
        }
        return total;
    }

    private void getCurrentTransactionStat(PlatformTestingToolState state) {
        long fcmCreateAmount = this.summation((List<TransactionCounter>)((Object)state.getTransactionCounter()), o -> o.fcmCreateAmount);
        long fcmUpdateAmount = this.summation((List<TransactionCounter>)((Object)state.getTransactionCounter()), o -> o.fcmUpdateAmount);
        long fcmTransferAmount = this.summation((List<TransactionCounter>)((Object)state.getTransactionCounter()), o -> o.fcmTransferAmount);
        long fcmDeleteAmount = this.summation((List<TransactionCounter>)((Object)state.getTransactionCounter()), o -> o.fcmDeleteAmount);
        long vmCreateAmount = this.summation((List<TransactionCounter>)((Object)state.getTransactionCounter()), o -> o.vmCreateAmount);
        long vmDeleteAmount = this.summation((List<TransactionCounter>)((Object)state.getTransactionCounter()), o -> o.vmDeleteAmount);
        long vmUpdateAmount = this.summation((List<TransactionCounter>)((Object)state.getTransactionCounter()), o -> o.vmUpdateAmount);
        long vmContractCreateAmount = this.summation((List<TransactionCounter>)((Object)state.getTransactionCounter()), o -> o.vmContractCreateAmount);
        long vmContractExecutionAmount = this.summation((List<TransactionCounter>)((Object)state.getTransactionCounter()), o -> o.vmContractExecutionAmount);
        this.totalFCMTransactions = fcmCreateAmount + fcmUpdateAmount + fcmTransferAmount + fcmDeleteAmount;
        this.fcmCreateSpeed.update((double)(fcmCreateAmount - this.prevFCMCreateAmount));
        this.fcmUpdateSpeed.update((double)(fcmUpdateAmount - this.prevFCMUpdateAmount));
        this.fcmTransferSpeed.update((double)(fcmTransferAmount - this.prevFCMTransferAmount));
        this.fcmDeleteSpeed.update((double)(fcmDeleteAmount - this.prevFCMDeleteAmount));
        this.vmCreateSpeed.update((double)(vmCreateAmount - this.prevVMCreateAmount));
        this.vmUpdateSpeed.update((double)(vmUpdateAmount - this.prevVMUpdateAmount));
        this.vmDeleteSpeed.update((double)(vmDeleteAmount - this.prevVMDeleteAmount));
        this.vmContractCreateSpeed.update((double)(vmContractCreateAmount - this.prevContractCreateAmount));
        this.vmContractExecutionSpeed.update((double)(vmContractExecutionAmount - this.prevContractExecutionAmount));
        this.prevFCMCreateAmount = fcmCreateAmount;
        this.prevFCMUpdateAmount = fcmUpdateAmount;
        this.prevFCMTransferAmount = fcmTransferAmount;
        this.prevFCMDeleteAmount = fcmDeleteAmount;
        this.prevVMCreateAmount = vmCreateAmount;
        this.prevVMUpdateAmount = vmUpdateAmount;
        this.prevVMDeleteAmount = vmDeleteAmount;
        this.prevContractCreateAmount = vmContractCreateAmount;
        this.prevContractExecutionAmount = vmContractExecutionAmount;
        if (PlatformTestingToolState.totalTransactionSignatureCount.get() > 0L) {
            this.expectedInvalidSigRatio.update((double)PlatformTestingToolState.expectedInvalidSignatureCount.get() / (double)PlatformTestingToolState.totalTransactionSignatureCount.get());
        }
    }

    private static InputStream resolveConfigFile(String fileName) throws IOException {
        ClassLoader classLoader = PlatformTestingToolMain.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(fileName);
        if (stream == null) {
            File inputFile = new File(fileName);
            if (!inputFile.exists() || !inputFile.isFile()) {
                throw new FileNotFoundException(fileName);
            }
            stream = new FileInputStream(inputFile);
        }
        return stream;
    }

    public static PayloadCfgSimple getPayloadCfgSimple(String jsonFileName) {
        try {
            if (jsonFileName != null && jsonFileName.length() > 0) {
                ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
                SuperConfig currentConfig = (SuperConfig)objectMapper.readValue(PlatformTestingToolMain.resolveConfigFile(jsonFileName), SuperConfig.class);
                return currentConfig.getPayloadConfig();
            }
            return null;
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "ERROR in getting PayloadCfgSimple, please check JSON file syntax. Stack Trace =", (Throwable)e);
            System.exit(-2);
            return null;
        }
    }

    public void init(Platform platform, NodeId id) {
        this.platform = platform;
        this.selfId = id;
        platform.getNotificationEngine().register(PlatformStatusChangeListener.class, (Listener)((PlatformStatusChangeListener)this::platformStatusChange));
        this.registerReconnectCompleteListener();
        try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(platform.getSelfId());){
            PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
            this.consensusStateEventHandler.initControlStructures(this::handleMessageQuorum);
            String myName = RosterUtils.formatNodeName((long)platform.getSelfId().id());
            String jsonFileName = null;
            String[] parameters = ParameterProvider.getInstance().getParameters();
            if (parameters != null && parameters.length > 0) {
                jsonFileName = parameters[0];
            }
            ProgressCfg progressCfg = new ProgressCfg();
            if (jsonFileName != null && jsonFileName.length() > 0) {
                ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
                try {
                    this.printJVMParameters();
                    logger.info(LOGM_STARTUP, "Parsing JSON {}", (Object)jsonFileName);
                    this.currentConfig = (SuperConfig)objectMapper.readValue(PlatformTestingToolMain.resolveConfigFile(jsonFileName), SuperConfig.class);
                    FCMConfig fcmConfig = this.currentConfig.getFcmConfig();
                    fcmConfig.loadSequentials();
                    fcmConfig.loadVirtualMerkleSequentials(this.currentConfig.getVirtualMerkleConfig());
                    PayloadCfgSimple pConfig = this.currentConfig.getPayloadConfig();
                    PayloadConfig payloadConfig = this.buildPayloadConfig(pConfig);
                    this.enableCheck = pConfig.isEnableCheck();
                    if (!this.enableCheck && !pConfig.isPerformOnDeleted()) {
                        payloadConfig.setPerformOnDeleted(true);
                    }
                    this.initBasedOnPayloadCfgSimple(pConfig);
                    this.payloadConfig = payloadConfig;
                    SyntheticBottleneckConfig.setActiveConfig(this.currentConfig.getSyntheticBottleneckConfig());
                    progressCfg.setProgressMarker(pConfig.getProgressMarker());
                    payloadConfig.display();
                    state.setPayloadConfig(this.currentConfig.getFcmConfig(), platform.getRoster());
                    if (this.currentConfig.getFcmConfig().getFcmQueryConfig() != null) {
                        this.queryController = new FCMQueryController(this.currentConfig.getFcmConfig().getFcmQueryConfig(), platform);
                    }
                    this.nftQueryController = new NftQueryController(this.currentConfig.getNftConfig(), platform);
                    this.submitConfig = this.currentConfig.getSubmitConfig();
                    this.submitter = new TransactionSubmitter(this.submitConfig, this.consensusStateEventHandler.getControlQuorum());
                    if (this.currentConfig.getFcmConfig() != null) {
                        state.initChildren();
                        VirtualMerkleConfig virtualMerkleConfig = this.currentConfig.getVirtualMerkleConfig();
                        if (virtualMerkleConfig != null) {
                            Pair<Long, Long> entitiesFirstIds = this.extractFirstIdForEntitiesFromSavedState(platform);
                            virtualMerkleConfig.setFirstAccountId((Long)entitiesFirstIds.key());
                            virtualMerkleConfig.setFirstSmartContractId((Long)entitiesFirstIds.value());
                            VirtualMerkleStateInitializer.initStateChildren(platform, this.selfId.id(), virtualMerkleConfig);
                        }
                        Metrics metrics = platform.getContext().getMetrics();
                        if (state.getVirtualMap() != null) {
                            state.getVirtualMap().registerMetrics(metrics);
                        }
                        if (state.getVirtualMapForSmartContracts() != null) {
                            state.getVirtualMapForSmartContracts().registerMetrics(metrics);
                        }
                        if (state.getVirtualMapForSmartContractsByteCode() != null) {
                            state.getVirtualMapForSmartContractsByteCode().registerMetrics(metrics);
                        }
                        this.initializeProgressCfgForSequentialTest(progressCfg, this.currentConfig);
                    }
                    this.pttTransactionPool = new PttTransactionPool(platform, platform.getSelfId().id(), payloadConfig, myName, this.currentConfig.getFcmConfig(), this.currentConfig.getVirtualMerkleConfig(), this.currentConfig.getFreezeConfig(), this.currentConfig.getTransactionPoolConfig(), this.submitter, state.getStateExpectedMap(), this.currentConfig.getIssConfig());
                    if (this.submitConfig != null) {
                        this.allowRunSubmit = this.submitConfig.isAllowRunSubmit();
                    }
                    if (this.currentConfig.getQueryConfig() != null) {
                        this.queriesSentPerSec = this.currentConfig.getQueryConfig().getQueriesSentPerSec();
                        logger.info(LOGM_DEMO_INFO, "queriesSentPerSec: {}", (Object)this.queriesSentPerSec);
                    }
                    this.initializeAppClient(parameters, objectMapper);
                }
                catch (IOException | NullPointerException e) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "ERROR in parsing JSON configuration file, please check JSON file syntax. Stack Trace =", (Throwable)e);
                    System.exit(-2);
                }
            }
            state.setProgressCfg(progressCfg);
        }
        catch (NullPointerException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "ERROR in parsing JSON configuration file. ", (Throwable)e);
            System.exit(-2);
        }
        this.initAppStat();
        if (this.waitForSaveStateDuringFreeze) {
            this.registerFinishAfterSaveStateDuringFreezeListener();
        }
        platform.getNotificationEngine().register(NewSignedStateListener.class, (Listener)((NewSignedStateListener)notification -> {
            if (this.timeToCheckBalances(notification.getConsensusTimestamp())) {
                this.checkBalances((PlatformTestingToolState)notification.getState());
            }
        }));
    }

    private PayloadConfig buildPayloadConfig(PayloadCfgSimple pConfig) {
        return PayloadConfig.builder().setAppendSig(pConfig.isAppendSig()).setInsertSeq(pConfig.isInsertSeq()).setVariedSize(pConfig.isVariedSize()).setPayloadByteSize(pConfig.getPayloadByteSize()).setMaxByteSize(pConfig.getMaxByteSize()).setType(pConfig.getType()).setDistribution(pConfig.getDistribution()).setInvalidSigRatio(pConfig.getInvalidSigRatio()).setCreateOnExistingEntities(pConfig.isCreateOnExistingEntities()).setPerformOnDeleted(pConfig.isPerformOnDeleted()).setPerformOnNonExistingEntities(pConfig.isPerformOnNonExistingEntities()).setOperateEntitiesOfSameNode(pConfig.isOperateEntitiesOfSameNode()).setRatioOfFCMTransaction(pConfig.getRatioOfFCMTransaction()).build();
    }

    private void initBasedOnPayloadCfgSimple(PayloadCfgSimple pConfig) {
        this.waitForSaveStateDuringFreeze = pConfig.isWaitForSaveStateDuringFreeze();
        this.saveExpectedMapAtFreeze = pConfig.isSaveExpectedMapAtFreeze();
        this.queryRecord = pConfig.isQueryRecord();
    }

    private void initializeAppClient(String[] pars, ObjectMapper objectMapper) throws IOException {
        if (pars == null || pars.length < 2 || !this.selfId.equals((Object)NodeId.of((long)0L))) {
            return;
        }
        String jsonFileName = pars[1];
        if (jsonFileName.trim().isBlank()) {
            return;
        }
        logger.info(LOGM_DEMO_INFO, "Parsing JSON for client: {}", (Object)jsonFileName);
        SuperConfig clientConfig = (SuperConfig)objectMapper.readValue(new File(jsonFileName), SuperConfig.class);
        String selfName = RosterUtils.formatNodeName((long)this.selfId.id());
        for (int k = 0; k < 2; ++k) {
            this.appClient[k] = new AppClient(this.platform, this.selfId, clientConfig, selfName, this.consensusStateEventHandler);
            this.appClient[k].start();
        }
    }

    private void initializeProgressCfgForSequentialTest(ProgressCfg progressCfg, SuperConfig currentConfig) {
        if (!currentConfig.getFcmConfig().isSequentialTest()) {
            return;
        }
        progressCfg.setExpectedFCMCreateAmount(currentConfig.getFcmConfig().getTranAmountByType(PAYLOAD_TYPE.TYPE_FCM_CREATE) * (long)this.platform.getRoster().rosterEntries().size());
        progressCfg.setExpectedFCMTransferAmount(currentConfig.getFcmConfig().getTranAmountByType(PAYLOAD_TYPE.TYPE_FCM_TRANSFER) * (long)this.platform.getRoster().rosterEntries().size());
        progressCfg.setExpectedFCMUpdateAmount(currentConfig.getFcmConfig().getTranAmountByType(PAYLOAD_TYPE.TYPE_FCM_UPDATE) * (long)this.platform.getRoster().rosterEntries().size());
        progressCfg.setExpectedFCMDeleteAmount(currentConfig.getFcmConfig().getTranAmountByType(PAYLOAD_TYPE.TYPE_FCM_DELETE) * (long)this.platform.getRoster().rosterEntries().size());
        progressCfg.setExpectedFCMAssortedAmount(currentConfig.getFcmConfig().getTranAmountByType(PAYLOAD_TYPE.TYPE_FCM_ASSORTED) * (long)this.platform.getRoster().rosterEntries().size());
    }

    public void run() {
        if (this.queryRecord) {
            Thread queryRecordThread = new Thread(this::queryRecord);
            queryRecordThread.setName("queryRecord_node" + String.valueOf(this.selfId));
            queryRecordThread.start();
        }
        if (this.queriesSentPerSec > 0L) {
            this.queryInState();
        }
        if (this.queryController != null) {
            this.queryController.launch();
        }
        this.nftQueryController.launch();
        try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(this.platform.getSelfId());){
            PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
            state.resetLastFileTranFinishTimeStamp();
        }
        if (this.allowRunSubmit && (!this.submitConfig.isSingleNodeSubmit() || this.selfId.equals((Object)NodeId.of((long)0L)))) {
            if (this.submitConfig.isSubmitInTurn()) {
                try {
                    Thread.sleep((long)(this.submitConfig.getInTurnIntervalSecond() * 1000) * this.selfId.id());
                }
                catch (InterruptedException wrapper) {
                    // empty catch block
                }
            }
            logger.info(LOGM_DEMO_INFO, "Node {} starts transactions ........", (Object)this.selfId);
            while (!this.noMoreTransaction) {
                while (!this.isActive) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        logger.error(LogMarker.EXCEPTION.getMarker(), "", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
                this.subRoutine();
                if (!this.noMoreTransaction || this.enableCheck || this.waitForSaveStateDuringFreeze) continue;
                logger.info(LOGM_DEMO_INFO, () -> new ApplicationFinishedPayload("Transactions finished"));
            }
            logger.info(LOGM_DEMO_INFO, "Node {} finished generating all transactions.", (Object)this.selfId);
            while (true) {
                Uninterruptable.abortAndThrowIfInterrupted(() -> Thread.sleep(60000L), (String)"PTT main thread interrupted");
            }
        }
    }

    @NonNull
    public PlatformTestingToolState newStateRoot() {
        PlatformTestingToolState state = new PlatformTestingToolState();
        TestingAppStateInitializer.DEFAULT.initStates((MerkleNodeState)state);
        return state;
    }

    @NonNull
    public ConsensusStateEventHandler<PlatformTestingToolState> newConsensusStateEvenHandler() {
        return this.consensusStateEventHandler;
    }

    private void platformStatusChange(PlatformStatusChangeNotification notification) {
        PlatformStatus newStatus = notification.getNewStatus();
        boolean bl = this.isActive = newStatus == PlatformStatus.ACTIVE;
        if (newStatus == PlatformStatus.FREEZING) {
            logger.trace(LOGM_DEMO_INFO, "ENTERING FREEZING!");
            logger.trace(LOGM_DEMO_INFO, "total submitted transactions: {}, FCM Transactions: {}", (Object)this.transactionSubmitted, (Object)this.totalFCMTransactions);
        }
        logger.info(LOGM_STARTUP, "Platform Status Change {} ", (Object)newStatus);
    }

    public SemanticVersion getSemanticVersion() {
        return semanticVersion;
    }

    private boolean timeToCheckBalances(Instant consensusTimestamp) {
        int checkPeriodSec = 20;
        if (this.previousTimestamp != null && consensusTimestamp.getEpochSecond() / 20L != this.previousTimestamp.getEpochSecond() / 20L) {
            this.previousTimestamp = consensusTimestamp;
            return true;
        }
        this.previousTimestamp = consensusTimestamp;
        return false;
    }

    private void checkBalances(PlatformTestingToolState state) {
        long totalBalance = 0L;
        MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> accountMap = state.getStateMap().getAccountFCQMap();
        for (Map.Entry item : accountMap.entrySet()) {
            MapValueFCQ currMv = (MapValueFCQ)((Object)item.getValue());
            totalBalance += currMv.getBalance().getValue();
        }
    }

    private void queryRecord() {
        Random random = new Random();
        try {
            Thread.sleep(3000L);
            while (true) {
                block10: {
                    try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(this.platform.getSelfId());){
                        PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
                        if (state == null) break block10;
                        int randomId = random.nextInt(this.platform.getRoster().rosterEntries().size());
                        TransactionCounter txCounter = (TransactionCounter)state.getTransactionCounter().get(randomId);
                        int accountsCount = (int)txCounter.fcmFCQCreateAmount;
                        if (accountsCount <= 0) break block10;
                        int randomAccountNum = random.nextInt(accountsCount);
                        MapKey key = new MapKey((long)randomId, (long)randomId, (long)randomAccountNum);
                        MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> accountMap = state.getStateMap().getAccountFCQMap();
                        FCQueue records = ((MapValueFCQ)accountMap.get((Object)key)).getRecords();
                        if (records.isEmpty()) break block10;
                        int randomIndex = random.nextInt(records.size());
                        for (TransactionRecord record : records) {
                            if (record.getIndex() != (long)randomIndex) continue;
                            record.getBalance();
                            break;
                        }
                    }
                }
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "error(ERROR queryRecord", (Throwable)e);
            return;
        }
    }

    private void registerReconnectCompleteListener() {
        this.platform.getNotificationEngine().register(ReconnectCompleteListener.class, (Listener)((ReconnectCompleteListener)notification -> {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((ReconnectCompleteNotification)notification).getConsensusTimestamp();
            supplierArray[1] = () -> ((ReconnectCompleteNotification)notification).getRoundNumber();
            supplierArray[2] = () -> ((ReconnectCompleteNotification)notification).getSequence();
            logger.info(LOGM_DEMO_INFO, "Notification Received: Reconnect Finished. consensusTimestamp: {}, roundNumber: {}, sequence: {}", supplierArray);
            ExpectedMapUtils.buildExpectedMapAfterReconnect(notification, this.platform);
            this.rebuildExpirationQueue(this.platform);
            try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(this.platform.getSelfId());){
                PlatformTestingToolState state = (PlatformTestingToolState)((Object)((Object)wrapper.get()));
                this.consensusStateEventHandler.initControlStructures(this::handleMessageQuorum);
                SyntheticBottleneckConfig.getActiveConfig().registerReconnect(this.platform.getSelfId().id());
            }
        }));
    }

    private void rebuildExpirationQueue(Platform platform) {
        try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(platform.getSelfId());){
            PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
            state.rebuildExpirationQueue();
        }
    }

    private Pair<Long, Long> extractFirstIdForEntitiesFromSavedState(Platform platform) {
        try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(platform.getSelfId());){
            PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
            AtomicLong maxAccountIdFromLoadedState = new AtomicLong(0L);
            if (state.getVirtualMap() != null) {
                new MerkleIterator(state.getVirtualMap()).setFilter(node -> node instanceof VirtualLeafNode).forEachRemaining(leaf -> {
                    AccountVirtualMapKey key = (AccountVirtualMapKey)leaf.getKey();
                    maxAccountIdFromLoadedState.set(Math.max(key.getAccountID() + 1L, maxAccountIdFromLoadedState.get()));
                });
            }
            AtomicLong maxSmartContractIdFromLoadedState = new AtomicLong(0L);
            if (state.getVirtualMapForSmartContractsByteCode() != null) {
                new MerkleIterator(state.getVirtualMapForSmartContractsByteCode()).setFilter(node -> node instanceof VirtualLeafNode).forEachRemaining(leaf -> {
                    SmartContractByteCodeMapKey key = (SmartContractByteCodeMapKey)leaf.getKey();
                    maxSmartContractIdFromLoadedState.set(Math.max(key.getContractId() + 1L, maxSmartContractIdFromLoadedState.get()));
                });
            }
            Pair pair = Pair.of((Object)maxAccountIdFromLoadedState.get(), (Object)maxSmartContractIdFromLoadedState.get());
            return pair;
        }
    }

    private void registerFinishAfterSaveStateDuringFreezeListener() {
        this.platform.getNotificationEngine().register(StateWriteToDiskCompleteListener.class, (Listener)((StateWriteToDiskCompleteListener)notification -> {
            if (notification.isFreezeState() && this.handledExitValidation.get()) {
                this.logSuccessMessageAndFinishTest(notification.getConsensusTimestamp());
            }
        }));
    }

    private void handleMessageQuorum(long id, ControlAction state) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> id;
        supplierArray[1] = state::getType;
        supplierArray[2] = state::getTimestamp;
        logger.info(LogMarker.DEMO_INFO.getMarker(), "Handling Quorum Transition [ triggeringNodeId = {}, type = {}, consensusTime = {} ]", supplierArray);
        switch (state.getType()) {
            case ENTER_VALIDATION: {
                this.handleEnterValidation(state.getTimestamp());
                break;
            }
            case EXIT_VALIDATION: {
                this.handleExitValidation(state.getTimestamp());
                break;
            }
            case ENTER_SYNC: {
                this.handleEnterSync(state.getTimestamp());
                break;
            }
            case EXIT_SYNC: {
                this.handleExitSync(state.getTimestamp());
            }
        }
    }

    private void handleEnterValidation(Instant consensusTime) {
        Runnable fn = () -> {
            try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(this.platform.getSelfId());){
                PlatformTestingToolState state = (PlatformTestingToolState)((Object)((Object)wrapper.get()));
                String expectedMapFile = SaveExpectedMapHandler.createExpectedMapName((long)this.platform.getSelfId().id(), (Instant)consensusTime);
                logger.info(LOGM_DEMO_QUORUM, "Achieved Quorum on ENTER_VALIDATION transaction [ expectedMapFile = {}, consensusTime = {} ]", (Object)expectedMapFile, (Object)consensusTime);
                VirtualMerkleTransactionHandler.handleExpectedMapValidation(state.getStateExpectedMap(), state.getVirtualMap());
                SaveExpectedMapHandler.serialize(state.getStateExpectedMap().getExpectedMap(), (File)new File("data/lifecycle"), (String)expectedMapFile, (boolean)false);
                logger.info(LOGM_DEMO_QUORUM, "Successfully wrote expected map to file [ expectedMapFile = {}, consensusTime = {} ]", (Object)expectedMapFile, (Object)consensusTime);
                this.submitter.sendTransaction(this.platform, this.pttTransactionPool.createControlTranBytes(ControlType.EXIT_VALIDATION));
                logger.info(LOGM_DEMO_QUORUM, "Sent EXIT_VALIDATION transaction  [ consensusTime = {} ]", (Object)consensusTime);
            }
        };
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setNodeId(this.platform.getSelfId())).setComponent(PTT_COMPONENT)).setThreadName(ENTER_VALIDATION_THREAD_NAME)).setRunnable(fn).build().start();
    }

    private void handleExitValidation(Instant consensusTime) {
        Runnable fn = () -> {
            logger.info(LOGM_DEMO_QUORUM, "Achieved Quorum on EXIT_VALIDATION transaction [ consensusTime = {} ]", (Object)consensusTime);
            this.handledExitValidation.set(true);
            if (this.platform.getSelfId().id() == 0L) {
                this.sendFreezeTransaction();
            }
            if (this.waitForSaveStateDuringFreeze) {
                logger.info(LOGM_DEMO_QUORUM, "Waiting for final state to save before terminating");
            } else {
                this.logSuccessMessageAndFinishTest(consensusTime);
            }
        };
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setNodeId(this.platform.getSelfId())).setComponent(PTT_COMPONENT)).setThreadName(EXIT_VALIDATION_THREAD_NAME)).setRunnable(fn).build().start();
    }

    private void handleEnterSync(Instant consensusTime) {
        logger.info(LOGM_DEMO_QUORUM, "Achieved Quorum on ENTER_SYNC transaction [ consensusTime = {} ]", (Object)consensusTime);
        this.submitter.sendTransaction(this.platform, this.pttTransactionPool.createControlTranBytes(ControlType.EXIT_SYNC));
        logger.info(LOGM_DEMO_QUORUM, "Sent EXIT_SYNC transaction  [ consensusTime = {} ]", (Object)consensusTime);
    }

    private void handleExitSync(Instant consensusTime) {
        logger.info(LOGM_DEMO_QUORUM, "Achieved Quorum on EXIT_SYNC transaction [ consensusTime = {} ]", (Object)consensusTime);
    }

    private void logSuccessMessageAndFinishTest(Instant consensusTime) {
        long sleepTime = this.submitter.getSubmitConfig().getSleepAfterTestMs();
        logger.info(LOGM_DEMO_QUORUM, "Preparing to terminate the JVM [ sleepAfterTestMs = {}, consensusTime = {} ]", (Object)sleepTime, (Object)consensusTime);
        logger.info(LOGM_DEMO_INFO, () -> new ApplicationFinishedPayload("Test success: Reached quorum on the EXIT_VALIDATION transaction, consensus time = " + consensusTime.toString()));
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            logger.info(LOGM_DEMO_QUORUM, "exit-validator thread was interrupted. Continuing process exit.");
            Thread.currentThread().interrupt();
        }
        if (this.currentConfig.isQuitJVMAfterTest()) {
            logger.info(LOGM_DEMO_QUORUM, "Terminating the JVM [ consensusTime = {} ]", (Object)consensusTime);
            SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.NO_ERROR);
        }
    }

    private void queryInState() {
        long periodInNanos = 1000000000L / this.queriesSentPerSec;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(3);
        ScheduledFuture<?> future = scheduledThreadPoolExecutor.scheduleAtFixedRate(() -> {
            try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(this.platform.getSelfId());){
                StopWatch watch = new StopWatch();
                watch.start();
                PlatformTestingToolState state = (PlatformTestingToolState)((Object)((Object)wrapper.get()));
                watch.suspend();
                if (state != null) {
                    MapKey mapKey = state.getStateExpectedMap().getMapKeyForQuery(EntityType.Crypto);
                    watch.resume();
                    MapValueData value = (MapValueData)state.getStateMap().getMap().get((Object)mapKey);
                    if (value != null) {
                        value.getBalance();
                    }
                    watch.stop();
                    this.queryLeafTimeCostMicroSec.update((double)watch.getTime(TimeUnit.MICROSECONDS));
                    this.queriesAnsweredPerSecond.update(1.0);
                } else {
                    watch.stop();
                }
            }
        }, 0L, periodInNanos, TimeUnit.NANOSECONDS);
        Thread queryInStateThread = new Thread(() -> {
            try {
                future.get();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Got Exception in queryInState() ", (Throwable)ex);
            }
        });
        queryInStateThread.setName("queryInState_node" + String.valueOf(this.selfId));
        queryInStateThread.start();
    }

    @NonNull
    public Bytes encodeSystemTransaction(@NonNull com.hedera.hapi.platform.event.StateSignatureTransaction transaction) {
        StateSignatureTransaction convertedSystemTransaction = StateSignatureTransaction.newBuilder().setRound(transaction.round()).setSignature(ByteString.copyFrom((byte[])transaction.signature().toByteArray())).setHash(ByteString.copyFrom((byte[])transaction.hash().toByteArray())).build();
        TestTransaction testTransaction = TestTransaction.newBuilder().setStateSignatureTransaction(convertedSystemTransaction).build();
        if (this.currentConfig.getPayloadConfig().isAppendSig()) {
            TestTransactionWrapper testTransactionWrapper = TestTransactionWrapper.newBuilder().setTestTransactionRawBytes(ByteString.copyFrom((byte[])testTransaction.toByteArray())).build();
            return Bytes.wrap((byte[])testTransactionWrapper.toByteArray());
        }
        return Bytes.wrap((byte[])testTransaction.toByteArray());
    }

    static {
        try {
            logger.info(LogMarker.STARTUP.getMarker(), "Registering PlatformTestingToolState with ConstructableRegistry");
            ConstructableRegistry.getInstance().registerConstructable(new ClassConstructorPair(PlatformTestingToolState.class, () -> {
                PlatformTestingToolState ptt = new PlatformTestingToolState();
                return ptt;
            }));
            logger.info(LogMarker.STARTUP.getMarker(), "PlatformTestingToolState is registered with ConstructableRegistry: {}", (Object)((NoArgsConstructor)ConstructableRegistry.getInstance().getRegistry(NoArgsConstructor.class).getConstructor(-4571139351850460298L)).get().getClassId());
            TestingAppStateInitializer.registerMerkleStateRootClassIds();
        }
        catch (ConstructableRegistryException e) {
            logger.error(LogMarker.STARTUP.getMarker(), "Failed to register PlatformTestingToolState", (Throwable)e);
            throw new RuntimeException(e);
        }
        TRANSACTION_SUBMITTED_CONFIG = new Counter.Config("Debug:info", "tranSub").withDescription("number of transactions submitted to platform");
        FCM_CREATE_SPEED_CONFIG = new SpeedometerMetric.Config(FCM_CATEGORY, "fcmCreate").withDescription("FCM Creation TPS");
        FCM_UPDATE_SPEED_CONFIG = new SpeedometerMetric.Config(FCM_CATEGORY, "fcmUpdate").withDescription("FCM Update TPS");
        FCM_TRANSFER_SPEED_CONFIG = new SpeedometerMetric.Config(FCM_CATEGORY, "fcmTransfer").withDescription("FCM Transfer TPS");
        FCM_DELETE_SPEED_CONFIG = new SpeedometerMetric.Config(FCM_CATEGORY, "fcmDelete").withDescription("FCM Delete TPS");
        VM_CREATE_SPEED_CONFIG = new SpeedometerMetric.Config(VM_CATEGORY, "vmCreate").withDescription("VM Creation TPS");
        VM_UPDATE_SPEED_CONFIG = new SpeedometerMetric.Config(VM_CATEGORY, "vmUpdate").withDescription("VM Update TPS");
        VM_DELETE_SPEED_CONFIG = new SpeedometerMetric.Config(VM_CATEGORY, "vmDelete").withDescription("VM Deletion TPS");
        VM_CONTRACT_CREATE_SPEED_CONFIG = new SpeedometerMetric.Config(VM_CATEGORY, "vmContractCreate").withDescription("VM Contract Creation TPS");
        VM_CONTRACT_EXECUTION_SPEED_CONFIG = new SpeedometerMetric.Config(VM_CATEGORY, "vmContractExecute").withDescription("VM Contract Execution TPS");
        TRAN_SUBMIT_TPS_SPEED_CONFIG = new SpeedometerMetric.Config("Debug:info", "tranSubTPS").withDescription("Transaction submitted TPS");
        QUERY_LEAF_TIME_COST_MICRO_SEC_CONFIG = new RunningAverageMetric.Config("Query", "queryLeafTimeCostMicroSec").withDescription("avg time taken to query a leaf in the latest signed state (in microseconds)").withHalfLife(10.0);
        QUERIES_ANSWERED_PER_SECOND_CONFIG = new SpeedometerMetric.Config("Query", "queriesAnsweredPerSecond").withDescription("number of queries have been answered per second").withFormat("%,9.6f");
        EXPECTED_INVALID_SIG_RATIO_CONFIG = new RunningAverageMetric.Config(FCM_CATEGORY, "expectedInvalidSigRatio").withDescription("Expected invalid signature ratio").withFormat("%,6.2f");
        semanticVersion = SemanticVersion.newBuilder().major(1).build();
    }

    private static interface ValueExtractor {
        public long getValue(TransactionCounter var1);
    }
}

