/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.util;

import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.SwirldsPlatform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MetricsDocUtils {
    private static final Logger logger = LogManager.getLogger(MetricsDocUtils.class);
    static final char FIELD_SEPARATOR = '\t';

    private MetricsDocUtils() {
    }

    public static void writeMetricsDocumentToFile(Metrics globalMetrics, Collection<SwirldsPlatform> platforms, Configuration configuration) {
        Objects.requireNonNull(globalMetrics, "globalMetrics must not be null");
        Objects.requireNonNull(platforms, "platforms must not be null");
        Objects.requireNonNull(configuration, "configuration must not be null");
        HashSet<Metric> combinedMetrics = new HashSet<Metric>(globalMetrics.getAll());
        for (SwirldsPlatform platform : platforms) {
            combinedMetrics.addAll(platform.getContext().getMetrics().getAll());
        }
        String metricsContents = MetricsDocUtils.generateMetricsDocContentsInTSV(combinedMetrics);
        String filePath = FileUtils.getUserDir() + File.separator + ((MetricsConfig)configuration.getConfigData(MetricsConfig.class)).metricsDocFileName();
        try (FileOutputStream outputStream = new FileOutputStream(filePath);){
            ((OutputStream)outputStream).write(metricsContents.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to write metrics information to file {}", (Object)filePath, (Object)e);
        }
    }

    private static String generateMetricsDocContentsInTSV(Collection<Metric> metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        List<Metric> sortedMetrics = metrics.stream().sorted((x, y) -> x.getIdentifier().compareToIgnoreCase(y.getIdentifier())).toList();
        StringBuilder sb = new StringBuilder();
        sb.append("Category").append('\t');
        sb.append("Identifier").append('\t');
        sb.append("Name").append('\t');
        sb.append("Metric Type").append('\t');
        sb.append("Data Type").append('\t');
        sb.append("Unit").append('\t');
        sb.append("Description").append(System.lineSeparator());
        for (Metric metric : sortedMetrics) {
            sb.append(metric.getCategory()).append('\t');
            sb.append(metric.getIdentifier()).append('\t');
            sb.append(metric.getName()).append('\t');
            sb.append(metric.getMetricType()).append('\t');
            sb.append(metric.getDataType()).append('\t');
            sb.append(metric.getUnit()).append('\t');
            sb.append(metric.getDescription()).append(System.lineSeparator());
        }
        return sb.toString();
    }
}

