/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.analysis;

import com.swirlds.component.framework.model.internal.analysis.ModelEdge;
import com.swirlds.component.framework.model.internal.analysis.ModelVertex;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DirectSchedulerChecks {
    private static final Logger logger = LogManager.getLogger(DirectSchedulerChecks.class);

    private DirectSchedulerChecks() {
    }

    public static boolean checkForIllegalDirectSchedulerUse(@NonNull Collection<ModelVertex> vertices) {
        boolean illegalAccessDetected = false;
        StringBuilder sb = new StringBuilder("Illegal direct scheduler use detected:\n");
        HashMap<ModelVertex, Set> directVertexCallers = new HashMap<ModelVertex, Set>();
        for (ModelVertex modelVertex : vertices) {
            TaskSchedulerType vertexType = modelVertex.getType();
            if (vertexType == TaskSchedulerType.DIRECT || vertexType == TaskSchedulerType.DIRECT_THREADSAFE) continue;
            Set<ModelVertex> directSchedulersAccessed = DirectSchedulerChecks.collectDirectVerticesAccessedByScheduler(modelVertex);
            if (vertexType == TaskSchedulerType.CONCURRENT && !directSchedulersAccessed.isEmpty()) {
                illegalAccessDetected = true;
                sb.append("  ").append(modelVertex.getName()).append(" is a concurrent scheduler that calls into direct scheduler(s):\n");
                for (ModelVertex directScheduler : directSchedulersAccessed) {
                    sb.append("    - ").append(directScheduler.getName()).append("\n");
                }
            }
            for (ModelVertex directScheduler : directSchedulersAccessed) {
                directVertexCallers.computeIfAbsent(directScheduler, k -> new HashSet()).add(modelVertex);
            }
        }
        for (Map.Entry entry : directVertexCallers.entrySet()) {
            ModelVertex directScheduler = (ModelVertex)entry.getKey();
            Set callers = (Set)entry.getValue();
            if (callers.size() <= 1) continue;
            illegalAccessDetected = true;
            sb.append("  ").append(directScheduler.getName()).append(" is called into by more than one non-direct scheduler:\n");
            for (ModelVertex caller : callers) {
                sb.append("    - ").append(caller.getName()).append("\n");
            }
        }
        if (illegalAccessDetected) {
            logger.error(LogMarker.EXCEPTION.getMarker(), sb.toString());
        } else {
            logger.info(LogMarker.STARTUP.getMarker(), "No illegal direct scheduler use detected in the wiring model.");
        }
        return illegalAccessDetected;
    }

    @NonNull
    private static Set<ModelVertex> collectDirectVerticesAccessedByScheduler(@NonNull ModelVertex scheduler) {
        HashSet<ModelVertex> directSchedulersAccessed = new HashSet<ModelVertex>();
        LinkedList<ModelVertex> stack = new LinkedList<ModelVertex>();
        HashSet<ModelVertex> visited = new HashSet<ModelVertex>();
        stack.addLast(scheduler);
        visited.add(scheduler);
        while (!stack.isEmpty()) {
            ModelVertex next = (ModelVertex)stack.removeLast();
            for (ModelEdge edge : next.getOutgoingEdges()) {
                ModelVertex destination = edge.getDestination();
                TaskSchedulerType destinationType = destination.getType();
                if (destinationType != TaskSchedulerType.DIRECT && destinationType != TaskSchedulerType.DIRECT_THREADSAFE) continue;
                if (destinationType == TaskSchedulerType.DIRECT) {
                    directSchedulersAccessed.add(destination);
                }
                if (!visited.add(destination)) continue;
                stack.addLast(destination);
                visited.add(destination);
            }
        }
        return directSchedulersAccessed;
    }
}

