/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent.locks;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.locks.ReentrantLock;
import org.hiero.base.concurrent.locks.AutoClosableLock;
import org.hiero.base.concurrent.locks.AutoClosableResourceLock;
import org.hiero.base.concurrent.locks.IndexLock;
import org.hiero.base.concurrent.locks.internal.AutoLock;
import org.hiero.base.concurrent.locks.internal.DefaultIndexLock;
import org.hiero.base.concurrent.locks.internal.ResourceLock;

public interface Locks {
    @NonNull
    public static IndexLock createIndexLock(int parallelism) {
        return new DefaultIndexLock(parallelism);
    }

    @NonNull
    public static AutoClosableLock createAutoLock() {
        return new AutoLock();
    }

    @NonNull
    public static <T> AutoClosableResourceLock<T> createResourceLock(@NonNull T resource) {
        return new ResourceLock<T>(new ReentrantLock(), resource);
    }
}

