/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures.merkle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.hapi.platform.state.StateKey;
import com.hedera.hapi.platform.state.StateValue;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.config.FileSystemManagerConfig;
import com.swirlds.common.io.config.TemporaryFileConfig;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.test.fixtures.AssertionUtils;
import com.swirlds.common.test.fixtures.merkle.TestMerkleCryptoFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkledb.MerkleDb;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.MerkleDbTableConfig;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.test.fixtures.MerkleDbTestUtils;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.memory.InMemoryKey;
import com.swirlds.state.merkle.memory.InMemoryValue;
import com.swirlds.state.merkle.queue.QueueNode;
import com.swirlds.state.merkle.singleton.SingletonNode;
import com.swirlds.state.test.fixtures.StateTestBase;
import com.swirlds.state.test.fixtures.TestArgumentUtils;
import com.swirlds.state.test.fixtures.merkle.TestLongCodec;
import com.swirlds.state.test.fixtures.merkle.TestStringCodec;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.constructable.ConstructableUtils;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.base.crypto.DigestType;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.provider.Arguments;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MerkleTestBase
extends StateTestBase {
    protected final Configuration CONFIGURATION = ConfigurationBuilder.create().withConfigDataType(VirtualMapConfig.class).withConfigDataType(MerkleDbConfig.class).withConfigDataType(TemporaryFileConfig.class).withConfigDataType(StateCommonConfig.class).withConfigDataType(FileSystemManagerConfig.class).build();
    public static final Codec<String> STRING_CODEC = TestStringCodec.SINGLETON;
    public static final Codec<Long> LONG_CODEC = TestLongCodec.SINGLETON;
    private static final String ON_DISK_KEY_CLASS_ID_SUFFIX = "OnDiskKey";
    private static final String ON_DISK_VALUE_CLASS_ID_SUFFIX = "OnDiskValue";
    private static final String ON_DISK_KEY_SERIALIZER_CLASS_ID_SUFFIX = "OnDiskKeySerializer";
    private static final String ON_DISK_VALUE_SERIALIZER_CLASS_ID_SUFFIX = "OnDiskValueSerializer";
    private static final String IN_MEMORY_VALUE_CLASS_ID_SUFFIX = "InMemoryValue";
    private static final String SINGLETON_CLASS_ID_SUFFIX = "SingletonLeaf";
    private static final String QUEUE_NODE_CLASS_ID_SUFFIX = "QueueNode";
    protected static final MerkleCryptography CRYPTO = TestMerkleCryptoFactory.getInstance();
    public static final long A_LONG_KEY = 0L;
    public static final long B_LONG_KEY = 1L;
    public static final long C_LONG_KEY = 2L;
    public static final long D_LONG_KEY = 3L;
    public static final long E_LONG_KEY = 4L;
    public static final long F_LONG_KEY = 5L;
    public static final long G_LONG_KEY = 6L;
    protected ConstructableRegistry registry;
    @TempDir
    protected Path virtualDbPath;
    protected String fruitLabel;
    protected MerkleMap<InMemoryKey<ProtoBytes>, InMemoryValue<ProtoBytes, ProtoBytes>> fruitMerkleMap;
    protected String fruitVirtualLabel;
    protected VirtualMap fruitVirtualMap;
    protected String animalLabel;
    protected MerkleMap<InMemoryKey<ProtoBytes>, InMemoryValue<ProtoBytes, ProtoBytes>> animalMerkleMap;
    protected String spaceLabel;
    protected MerkleMap<InMemoryKey<ProtoBytes>, InMemoryValue<ProtoBytes, ProtoBytes>> spaceMerkleMap;
    protected String steamLabel;
    protected QueueNode<ProtoBytes> steamQueue;
    protected String countryLabel;
    protected SingletonNode<ProtoBytes> countrySingleton;
    private static MockedStatic<StateUtils> stateUtilsMock;

    @BeforeAll
    static void init() {
        AtomicBoolean bypassStateIdFor = new AtomicBoolean(false);
        stateUtilsMock = Mockito.mockStatic(StateUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);
        stateUtilsMock.when(() -> StateUtils.stateIdFor((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            if (bypassStateIdFor.get()) {
                return invocation.callRealMethod();
            }
            try {
                return invocation.callRealMethod();
            }
            catch (Exception e) {
                String serviceName = (String)invocation.getArgument(0);
                String stateKey = (String)invocation.getArgument(1);
                if ("Plants".equals(serviceName) || "FRUIT".equals(stateKey)) {
                    return 3;
                }
                if ("Organisms".equals(serviceName) || "ANIMAL".equals(stateKey)) {
                    return 16;
                }
                if ("Universe".equals(serviceName) || "SPACE".equals(stateKey)) {
                    return 1;
                }
                if ("Learning".equals(serviceName) || "STEAM".equals(stateKey)) {
                    return 10001;
                }
                if ("Planets".equals(serviceName) || "COUNTRY".equals(stateKey)) {
                    return 11;
                }
                return 65000;
            }
        });
        stateUtilsMock.when(() -> StateUtils.getStateKeyForKv((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.any())).thenAnswer(invocation -> {
            try {
                bypassStateIdFor.set(true);
                Object object = invocation.callRealMethod();
                return object;
            }
            catch (Exception e) {
                String serviceName = (String)invocation.getArgument(0);
                String stateKey = (String)invocation.getArgument(1);
                ProtoBytes keyObject = (ProtoBytes)invocation.getArgument(2);
                if ("Plants".equals(serviceName) || "FRUIT".equals(stateKey)) {
                    Bytes bytes = MerkleTestBase.createStateKeyForKv(StateKey.KeyOneOfType.TOKENSERVICE_I_ALIASES, keyObject);
                    return bytes;
                }
                if ("Organisms".equals(serviceName) || "ANIMAL".equals(stateKey)) {
                    Bytes bytes = MerkleTestBase.createStateKeyForKv(StateKey.KeyOneOfType.SCHEDULESERVICE_I_SCHEDULES_BY_EQUALITY, keyObject);
                    return bytes;
                }
                Integer n = 65000;
                return n;
            }
            finally {
                bypassStateIdFor.set(false);
            }
        });
        stateUtilsMock.when(() -> StateUtils.getStateValue((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.any())).thenAnswer(invocation -> {
            try {
                bypassStateIdFor.set(true);
                Object object = invocation.callRealMethod();
                return object;
            }
            catch (Exception e) {
                String serviceName = (String)invocation.getArgument(0);
                String stateKey = (String)invocation.getArgument(1);
                ProtoBytes valueObject = (ProtoBytes)invocation.getArgument(2);
                if ("Plants".equals(serviceName) || "FRUIT".equals(stateKey)) {
                    StateValue stateValue = MerkleTestBase.createStateValue(StateValue.ValueOneOfType.FREEZESERVICE_I_UPGRADE_FILE_HASH, valueObject);
                    return stateValue;
                }
                if ("Organisms".equals(serviceName) || "ANIMAL".equals(stateKey)) {
                    StateValue stateValue = MerkleTestBase.createStateValue(StateValue.ValueOneOfType.HISTORYSERVICE_I_LEDGER_ID, valueObject);
                    return stateValue;
                }
                if ("Universe".equals(serviceName) || "SPACE".equals(stateKey)) {
                    StateValue stateValue = MerkleTestBase.createStateValue(StateValue.ValueOneOfType.FILESERVICE_I_UPGRADE_DATA_150, valueObject);
                    return stateValue;
                }
                if ("Learning".equals(serviceName) || "STEAM".equals(stateKey)) {
                    StateValue stateValue = MerkleTestBase.createStateValue(StateValue.ValueOneOfType.FILESERVICE_I_UPGRADE_DATA_151, valueObject);
                    return stateValue;
                }
                if ("Planets".equals(serviceName) || "COUNTRY".equals(stateKey)) {
                    StateValue stateValue = MerkleTestBase.createStateValue(StateValue.ValueOneOfType.FILESERVICE_I_UPGRADE_DATA_152, valueObject);
                    return stateValue;
                }
                Integer n = 65000;
                return n;
            }
            finally {
                bypassStateIdFor.set(false);
            }
        });
        stateUtilsMock.when(() -> StateUtils.getStateKeyForQueue((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (long)ArgumentMatchers.anyLong())).thenAnswer(invocation -> {
            try {
                bypassStateIdFor.set(true);
                Object object = invocation.callRealMethod();
                return object;
            }
            catch (Exception e) {
                String serviceName = (String)invocation.getArgument(0);
                String stateKey = (String)invocation.getArgument(1);
                Long keyObject = (Long)invocation.getArgument(2);
                if ("Learning".equals(serviceName) || "STEAM".equals(stateKey)) {
                    Bytes bytes = MerkleTestBase.createStateKeyForQueue(StateKey.KeyOneOfType.FILESERVICE_I_UPGRADE_DATA_150, keyObject);
                    return bytes;
                }
                Integer n = 65000;
                return n;
            }
            finally {
                bypassStateIdFor.set(false);
            }
        });
        stateUtilsMock.when(() -> StateUtils.getStateKeyForSingleton((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            try {
                bypassStateIdFor.set(true);
                Object object = invocation.callRealMethod();
                return object;
            }
            catch (Exception e) {
                String serviceName = (String)invocation.getArgument(0);
                String stateKey = (String)invocation.getArgument(1);
                if ("Universe".equals(serviceName) || "SPACE".equals(stateKey)) {
                    Bytes bytes = MerkleTestBase.createStateKeyForSingleton(SingletonType.ENTITYIDSERVICE_I_ENTITY_ID);
                    return bytes;
                }
                if ("Learning".equals(serviceName) || "STEAM".equals(stateKey)) {
                    Bytes bytes = MerkleTestBase.createStateKeyForSingleton(SingletonType.FILESERVICE_I_UPGRADE_DATA_150);
                    return bytes;
                }
                if ("Planets".equals(serviceName) || "COUNTRY".equals(stateKey)) {
                    Bytes bytes = MerkleTestBase.createStateKeyForSingleton(SingletonType.TOKENSERVICE_I_STAKING_NETWORK_REWARDS);
                    return bytes;
                }
                Integer n = 65000;
                return n;
            }
            finally {
                bypassStateIdFor.set(false);
            }
        });
    }

    private static Bytes createStateKeyForKv(StateKey.KeyOneOfType type, ProtoBytes keyObject) {
        return StateKey.PROTOBUF.toBytes((Object)new StateKey(new OneOf((Enum)type, (Object)keyObject)));
    }

    private static Bytes createStateKeyForSingleton(SingletonType type) {
        return StateKey.PROTOBUF.toBytes((Object)new StateKey(new OneOf((Enum)StateKey.KeyOneOfType.SINGLETON, (Object)type)));
    }

    private static Bytes createStateKeyForQueue(StateKey.KeyOneOfType type, Long index) {
        return StateKey.PROTOBUF.toBytes((Object)new StateKey(new OneOf((Enum)type, (Object)index)));
    }

    private static StateValue createStateValue(StateValue.ValueOneOfType type, ProtoBytes valueObject) {
        return new StateValue(new OneOf((Enum)type, (Object)valueObject));
    }

    protected void setupFruitMerkleMap() {
        this.fruitLabel = StateMetadata.computeLabel((String)"First-Service", (String)"FRUIT");
        this.fruitMerkleMap = this.createMerkleMap(this.fruitLabel);
    }

    protected void setupFruitVirtualMap() {
        this.fruitVirtualLabel = StateMetadata.computeLabel((String)"First-Service", (String)"FRUIT");
        this.fruitVirtualMap = this.createVirtualMap(this.fruitVirtualLabel);
    }

    protected static long queueNodeClassId(String stateKey) {
        return StateMetadata.computeClassId((String)"First-Service", (String)stateKey, (SemanticVersion)TEST_VERSION, (String)QUEUE_NODE_CLASS_ID_SUFFIX);
    }

    protected static long inMemoryValueClassId(String stateKey) {
        return StateMetadata.computeClassId((String)"First-Service", (String)stateKey, (SemanticVersion)TEST_VERSION, (String)IN_MEMORY_VALUE_CLASS_ID_SUFFIX);
    }

    protected static long singletonClassId(String stateKey) {
        return StateMetadata.computeClassId((String)"First-Service", (String)stateKey, (SemanticVersion)TEST_VERSION, (String)SINGLETON_CLASS_ID_SUFFIX);
    }

    protected void setupAnimalMerkleMap() {
        this.animalLabel = StateMetadata.computeLabel((String)"First-Service", (String)"ANIMAL");
        this.animalMerkleMap = this.createMerkleMap(this.animalLabel);
    }

    protected void setupSpaceMerkleMap() {
        this.spaceLabel = StateMetadata.computeLabel((String)"Second-Service", (String)"SPACE");
        this.spaceMerkleMap = this.createMerkleMap(this.spaceLabel);
    }

    protected void setupSingletonCountry() {
        this.countryLabel = StateMetadata.computeLabel((String)"First-Service", (String)"COUNTRY");
        this.countrySingleton = new SingletonNode("First-Service", "COUNTRY", StateMetadata.computeClassId((String)"First-Service", (String)"COUNTRY", (SemanticVersion)TEST_VERSION, (String)SINGLETON_CLASS_ID_SUFFIX), ProtoBytes.PROTOBUF, (Object)AUSTRALIA);
    }

    protected void setupSteamQueue() {
        this.steamLabel = StateMetadata.computeLabel((String)"First-Service", (String)"STEAM");
        this.steamQueue = new QueueNode("First-Service", "STEAM", StateMetadata.computeClassId((String)"First-Service", (String)"STEAM", (SemanticVersion)TEST_VERSION, (String)QUEUE_NODE_CLASS_ID_SUFFIX), StateMetadata.computeClassId((String)"First-Service", (String)"STEAM", (SemanticVersion)TEST_VERSION, (String)SINGLETON_CLASS_ID_SUFFIX), ProtoBytes.PROTOBUF);
    }

    protected void setupConstructableRegistry() {
        try {
            this.registry = ConstructableRegistry.getInstance();
            this.registry.reset();
            this.registry.registerConstructables("com.swirlds.merklemap");
            this.registry.registerConstructables("com.swirlds.merkledb");
            this.registry.registerConstructables("com.swirlds.fcqueue");
            this.registry.registerConstructables("com.swirlds.virtualmap");
            this.registry.registerConstructables("com.swirlds.common.merkle");
            this.registry.registerConstructables("com.swirlds.common");
            this.registry.registerConstructables("org.hiero");
            this.registry.registerConstructables("com.swirlds.merkle");
            this.registry.registerConstructables("com.swirlds.merkle.tree");
            ConstructableRegistry.getInstance().registerConstructable(new ClassConstructorPair(MerkleDbDataSourceBuilder.class, () -> new MerkleDbDataSourceBuilder(this.CONFIGURATION)));
            ConstructableUtils.registerVirtualMapConstructables((Configuration)this.CONFIGURATION);
        }
        catch (ConstructableRegistryException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected <K extends Comparable<ProtoBytes>, V> MerkleMap<InMemoryKey<ProtoBytes>, InMemoryValue<ProtoBytes, V>> createMerkleMap(String label) {
        MerkleMap map = new MerkleMap();
        map.setLabel(label);
        return map;
    }

    protected VirtualMap createVirtualMap(String label) {
        MerkleDbTableConfig merkleDbTableConfig = new MerkleDbTableConfig(1, DigestType.SHA_384, 100L, 0L);
        MerkleDbDataSourceBuilder builder = new MerkleDbDataSourceBuilder(this.virtualDbPath, merkleDbTableConfig, this.CONFIGURATION);
        return new VirtualMap(label, (VirtualDataSourceBuilder)builder, this.CONFIGURATION);
    }

    protected void addKvState(MerkleMap<InMemoryKey<ProtoBytes>, InMemoryValue<ProtoBytes, ProtoBytes>> map, long inMemoryValueClassId, Codec<ProtoBytes> keyCodec, Codec<ProtoBytes> valueCodec, ProtoBytes key, ProtoBytes value) {
        InMemoryKey k = new InMemoryKey((Object)key);
        map.put((Object)k, (MerkleNode)new InMemoryValue(inMemoryValueClassId, keyCodec, valueCodec, k, (Object)value));
    }

    protected void addSingletonState(VirtualMap map, String serviceName, String stateKey, ProtoBytes value) {
        map.put(StateUtils.getStateKeyForSingleton((String)serviceName, (String)stateKey), (Object)StateUtils.getStateValue((String)serviceName, (String)stateKey, (Object)value), StateValue.PROTOBUF);
    }

    protected void addKvState(VirtualMap map, String serviceName, String stateKey, ProtoBytes key, ProtoBytes value) {
        map.put(StateUtils.getStateKeyForKv((String)serviceName, (String)stateKey, (Object)key), (Object)StateUtils.getStateValue((String)serviceName, (String)stateKey, (Object)value), StateValue.PROTOBUF);
    }

    protected byte[] writeTree(@NonNull MerkleNode tree, @NonNull Path tempDir) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (MerkleDataOutputStream out = new MerkleDataOutputStream((OutputStream)byteOutputStream);){
            out.writeMerkleTree(tempDir, tree);
        }
        return byteOutputStream.toByteArray();
    }

    protected <T extends MerkleNode> T parseTree(@NonNull byte[] state, @NonNull Path tempDir) throws IOException {
        MerkleDb.resetDefaultInstancePath();
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(state);
        try (MerkleDataInputStream in = new MerkleDataInputStream((InputStream)byteInputStream);){
            MerkleNode merkleNode = in.readMerkleTree(this.CONFIGURATION, tempDir, 100);
            return (T)merkleNode;
        }
    }

    public static Stream<Arguments> illegalServiceNames() {
        return TestArgumentUtils.illegalIdentifiers();
    }

    public static Stream<Arguments> legalServiceNames() {
        return TestArgumentUtils.legalIdentifiers();
    }

    @AfterEach
    void cleanUp() {
        MerkleDb.resetDefaultInstancePath();
        if (this.fruitVirtualMap != null && this.fruitVirtualMap.getReservationCount() > -1) {
            this.fruitVirtualMap.release();
        }
        MerkleDbTestUtils.assertAllDatabasesClosed();
        AssertionUtils.assertEventuallyDoesNotThrow(() -> {
            try {
                FileUtils.deleteDirectory((Path)this.virtualDbPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, (Duration)Duration.of(1L, ChronoUnit.SECONDS), (String)"Unable to delete virtual map directory");
    }

    @AfterAll
    static void cleanUpStaticMocks() {
        stateUtilsMock.close();
    }
}

