/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerkleCopy;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteIterator;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.editor.StateEditor;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.editor.StateEditorUtils;
import com.swirlds.platform.state.signed.ReservedSignedState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hashable;
import picocli.CommandLine;

@CommandLine.Command(name="cp", mixinStandardHelpOptions=true, description={"Copy a node from one location to another."})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorCp
extends StateEditorOperation {
    private static final Logger logger = LogManager.getLogger(StateEditorCp.class);
    private String sourcePath;
    private String destinationPath = "";

    @CommandLine.Parameters(index="0", description={"The route of the node to be copied."})
    private void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @CommandLine.Parameters(index="1", arity="0..1", description={"The route where the node should be copied to."})
    private void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    @Override
    public void run() {
        StateEditor.ParentInfo parentInfo = this.getStateEditor().getParentInfo(this.destinationPath);
        MerkleRoute destinationRoute = parentInfo.target();
        MerkleInternal parent = parentInfo.parent();
        int indexInParent = parentInfo.indexInParent();
        MerkleNode source = this.getStateEditor().getRelativeNode(this.sourcePath);
        if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
            logger.info(LogMarker.CLI.getMarker(), "Copying {} to {} in parent {}", (Object)StateEditorUtils.formatNode(source), (Object)StateEditorUtils.formatRoute(destinationRoute), (Object)StateEditorUtils.formatParent((MerkleNode)parent, indexInParent));
        }
        MerkleCopy.copyTreeToLocation((MerkleInternal)parent.asInternal(), (int)indexInParent, (MerkleNode)source);
        try (ReservedSignedState reservedSignedState = this.getStateEditor().getState("StateEditorCp.run()");){
            new MerkleRouteIterator(reservedSignedState.get().getState().getRoot(), parent.getRoute()).forEachRemaining(Hashable::invalidateHash);
        }
    }
}

