/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import org.hiero.base.constructable.ConstructableIgnored;

@ConstructableIgnored
public class ExampleVariableKey {
    public static Bytes longToKey(long k) {
        byte len = ExampleVariableKey.computeNonZeroBytes(k);
        byte[] bytes = new byte[len];
        int b = len - 1;
        int i = 0;
        while (b >= 0) {
            bytes[i] = (byte)(k >> b * 8);
            --b;
            ++i;
        }
        return Bytes.wrap((byte[])bytes);
    }

    public static long keyToLong(Bytes key) {
        long k = 0L;
        int i = 0;
        while ((long)i < key.length()) {
            k = (k << 8) + (long)key.getByte((long)i);
            ++i;
        }
        return k;
    }

    static byte computeNonZeroBytes(long num) {
        if (num == 0L) {
            return 1;
        }
        return (byte)Math.ceil((double)(64 - Long.numberOfLeadingZeros(num)) / 8.0);
    }

    private ExampleVariableKey() {
    }
}

