/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.virtualmap;

import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.MerkleDbTableConfig;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.base.crypto.DigestType;

public final class VirtualMapUtils {
    public static VirtualMap createVirtualMap(@NonNull String label) {
        long MAX_NUM_OF_KEYS = 1000L;
        return VirtualMapUtils.createVirtualMap(label, 1000L);
    }

    public static VirtualMap createVirtualMap(@NonNull String label, long maxNumberOfKeys) {
        MerkleDbConfig merkleDbConfig = (MerkleDbConfig)TestingAppStateInitializer.CONFIGURATION.getConfigData(MerkleDbConfig.class);
        MerkleDbTableConfig tableConfig = new MerkleDbTableConfig(1, DigestType.SHA_384, maxNumberOfKeys, merkleDbConfig.hashesRamToDiskThreshold());
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(tableConfig, TestingAppStateInitializer.CONFIGURATION);
        return new VirtualMap(label, (VirtualDataSourceBuilder)dsBuilder, TestingAppStateInitializer.CONFIGURATION);
    }
}

