/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework.validation;

import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusRoundConsistencyValidation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.List;
import org.assertj.core.api.AbstractInstantAssert;
import org.assertj.core.api.Assertions;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public enum RoundTimestampCheckerValidation implements ConsensusRoundConsistencyValidation
{
    INSTANCE;


    @Override
    public void validate(@NonNull List<ConsensusRound> rounds) {
        for (ConsensusRound round : rounds) {
            for (int i = 1; i < round.getEventCount(); ++i) {
                PlatformEvent previousEvent = (PlatformEvent)round.getConsensusEvents().get(i - 1);
                PlatformEvent currentEvent = (PlatformEvent)round.getConsensusEvents().get(i);
                ((AbstractInstantAssert)Assertions.assertThat((Instant)currentEvent.getConsensusTimestamp()).withFailMessage(String.format("Consensus time does not increase!%nEvent %s consOrder:%s consTime:%s%nEvent %s consOrder:%s consTime:%s%n", previousEvent.getDescriptor(), previousEvent.getConsensusOrder(), previousEvent.getConsensusTimestamp(), currentEvent.getDescriptor(), currentEvent.getConsensusOrder(), currentEvent.getConsensusTimestamp()), new Object[0])).isAfter(previousEvent.getConsensusTimestamp());
            }
        }
    }
}

