/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.dummy;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleNode;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class SelfHashingDummyMerkleLeaf
extends PartialMerkleLeaf
implements DummyMerkleNode,
MerkleLeaf {
    private static final long CLASS_ID = -837173315198360715L;
    private static final int VERSION = 1;
    private static final int MAX_STRING_LENGTH = 1024;
    private final AtomicBoolean released = new AtomicBoolean(false);
    protected String value;
    private boolean returnNullForHash;

    public SelfHashingDummyMerkleLeaf() {
        this("?");
    }

    public SelfHashingDummyMerkleLeaf(String value) {
        this.value = value;
        this.returnNullForHash = false;
    }

    private SelfHashingDummyMerkleLeaf(SelfHashingDummyMerkleLeaf that) {
        super((PartialMerkleLeaf)that);
        this.value = that.value;
        this.returnNullForHash = that.returnNullForHash;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeNormalisedString(this.value);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.value = in.readNormalisedString(1024);
    }

    public long getClassId() {
        return -837173315198360715L;
    }

    public int getVersion() {
        return 1;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void destroyNode() {
        if (!this.released.compareAndSet(false, true)) {
            throw new IllegalStateException("This type of node should only be deleted once");
        }
    }

    public void setHash(Hash hash) {
        throw new UnsupportedOperationException();
    }

    public boolean isSelfHashing() {
        return true;
    }

    public Hash getHash() {
        if (this.returnNullForHash) {
            return null;
        }
        return Cryptography.NULL_HASH;
    }

    public void setReturnNullForHash(boolean returnNullForHash) {
        this.returnNullForHash = returnNullForHash;
    }

    public String toString() {
        return this.value;
    }

    public SelfHashingDummyMerkleLeaf copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        this.setImmutable(true);
        return new SelfHashingDummyMerkleLeaf(this);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SelfHashingDummyMerkleLeaf)) {
            return false;
        }
        SelfHashingDummyMerkleLeaf that = (SelfHashingDummyMerkleLeaf)obj;
        return Objects.equals(this.value, that.value);
    }
}

