/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.swirlds.platform.gui.GuiEventStorage;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import com.swirlds.platform.internal.EventImpl;
import java.util.List;
import org.hiero.consensus.model.roster.AddressBook;

public class CachingGuiSource
implements HashgraphGuiSource {
    private final HashgraphGuiSource source;
    private List<EventImpl> events = null;
    private AddressBook addressBook = null;
    private final GuiEventStorage eventStorage;
    private long maxGeneration = -1L;
    private long startGeneration = 0L;
    private int numGenerations = 25;

    public CachingGuiSource(HashgraphGuiSource source) {
        this.source = source;
        this.eventStorage = source.getEventStorage();
    }

    @Override
    public long getMaxGeneration() {
        return this.maxGeneration;
    }

    @Override
    public List<EventImpl> getEvents(long startGeneration, int numGenerations) {
        this.startGeneration = startGeneration;
        this.numGenerations = numGenerations;
        return this.events;
    }

    @Override
    public AddressBook getAddressBook() {
        return this.addressBook;
    }

    @Override
    public boolean isReady() {
        return this.events != null && this.addressBook != null && this.maxGeneration != -1L;
    }

    @Override
    public GuiEventStorage getEventStorage() {
        return this.eventStorage;
    }

    public void refresh() {
        if (this.source.isReady()) {
            this.events = this.source.getEvents(this.startGeneration, this.numGenerations);
            this.addressBook = this.source.getAddressBook();
            this.maxGeneration = this.source.getMaxGeneration();
        }
    }
}

