/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.util;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.TeachingSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.test.fixtures.merkle.util.LaggingAsyncOutputStream;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class LaggingTeachingSynchronizer
extends TeachingSynchronizer {
    private final int latencyMilliseconds;

    public LaggingTeachingSynchronizer(@NonNull PlatformContext platformContext, MerkleDataInputStream in, MerkleDataOutputStream out, MerkleNode root, int latencyMilliseconds, Runnable breakConnection, ReconnectConfig reconnectConfig) {
        super(platformContext.getConfiguration(), Time.getCurrent(), AdHocThreadManager.getStaticThreadManager(), in, out, root, breakConnection, reconnectConfig);
        this.latencyMilliseconds = latencyMilliseconds;
    }

    public <T extends SelfSerializable> AsyncOutputStream<T> buildOutputStream(StandardWorkGroup workGroup, SerializableDataOutputStream out) {
        return new LaggingAsyncOutputStream(out, workGroup, this.latencyMilliseconds, this.reconnectConfig);
    }
}

