/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.queue;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.merkle.utility.DebugIterationEndpoint;
import com.swirlds.common.utility.Labeled;
import com.swirlds.fcqueue.FCQueue;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.merkle.singleton.StringLeaf;
import com.swirlds.state.merkle.singleton.ValueLeaf;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;

@Deprecated
@DebugIterationEndpoint
public class QueueNode<E>
extends PartialBinaryMerkleInternal
implements Labeled,
MerkleInternal {
    private static final long CLASS_ID = 689331701178339804L;
    public static final int CLASS_VERSION = 1;
    private final Codec<E> codec;
    private final Long queueNodeClassId;
    private final Long leafClassId;

    @Deprecated(forRemoval=true)
    public QueueNode() {
        this.setLeft((MerkleNode)new StringLeaf());
        this.setRight(null);
        this.codec = null;
        this.queueNodeClassId = 689331701178339804L;
        this.leafClassId = 7324131901237876526L;
    }

    public QueueNode(@NonNull String serviceName, @NonNull String stateKey, long queueNodeClassId, long leafClassId, @NonNull Codec<E> codec) {
        this.setLeft((MerkleNode)new StringLeaf(StateMetadata.computeLabel((String)serviceName, (String)stateKey)));
        this.setRight((MerkleNode)new FCQueue());
        this.codec = Objects.requireNonNull(codec);
        this.queueNodeClassId = queueNodeClassId;
        this.leafClassId = leafClassId;
    }

    private QueueNode(@NonNull QueueNode<E> other) {
        this.setLeft(other.getLeft().copy());
        this.setRight(other.getRight().copy());
        this.codec = other.codec;
        this.queueNodeClassId = other.queueNodeClassId;
        this.leafClassId = other.leafClassId;
    }

    public QueueNode<E> copy() {
        return new QueueNode<E>(this);
    }

    public long getClassId() {
        return this.queueNodeClassId;
    }

    public int getVersion() {
        return 1;
    }

    public String getLabel() {
        StringLeaf left = (StringLeaf)this.getLeft();
        return left.getLabel();
    }

    public void add(E element) {
        this.getQueue().add(new ValueLeaf<E>(this.leafClassId, this.codec, element));
        StateLogger.logQueueAdd(this.getLabel(), element);
    }

    public E peek() {
        ValueLeaf valueLeaf = (ValueLeaf)this.getQueue().peek();
        StateLogger.logQueuePeek(this.getLabel(), valueLeaf);
        return valueLeaf == null ? null : (E)valueLeaf.getValue();
    }

    public E remove() {
        ValueLeaf valueLeaf = (ValueLeaf)this.getQueue().remove();
        StateLogger.logQueueRemove(this.getLabel(), valueLeaf);
        return valueLeaf == null ? null : (E)valueLeaf.getValue();
    }

    public Iterator<E> iterator() {
        StateLogger.logQueueIterate(this.getLabel(), (FCQueue)this.getRight());
        final Iterator itr = this.getQueue().stream().iterator();
        return new Iterator<E>(this){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public E next() {
                ValueLeaf valueLeaf = (ValueLeaf)((Object)itr.next());
                return valueLeaf == null ? null : (Object)valueLeaf.getValue();
            }
        };
    }

    private FCQueue<ValueLeaf<E>> getQueue() {
        return (FCQueue)this.getRight();
    }
}

