/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.copy;

import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class MerkleInitialize {
    private MerkleInitialize() {
    }

    public static MerkleNode initializeAndMigrateTreeAfterDeserialization(@NonNull Configuration configuration, MerkleNode root, Map<Long, Integer> deserializationVersions) {
        if (root == null) {
            return null;
        }
        Predicate<MerkleNode> filter = node -> !(node instanceof ExternalSelfSerializable);
        Predicate<MerkleInternal> descendantFilter = filter::test;
        root.treeIterator().setFilter(filter).setDescendantFilter(descendantFilter).forEachRemaining(node -> {
            MerkleInternal internal = node.asInternal();
            for (int childIndex = 0; childIndex < internal.getNumberOfChildren(); ++childIndex) {
                int deserializationVersion;
                MerkleNode migratedChild;
                MerkleNode child = internal.getChild(childIndex);
                if (child == null || (migratedChild = child.migrate(configuration, deserializationVersion = Objects.requireNonNull((Integer)deserializationVersions.get(child.getClassId()), "class not discovered during deserialization").intValue())) == child) continue;
                internal.setChild(childIndex, migratedChild);
            }
            node.asInternal().rebuild();
        });
        int deserializationVersion = Objects.requireNonNull(deserializationVersions.get(root.getClassId()), "class not discovered during deserialization");
        MerkleNode migratedRoot = root.migrate(configuration, deserializationVersion);
        if (migratedRoot != root) {
            root.release();
        }
        return migratedRoot;
    }

    public static void initializeTreeAfterCopy(MerkleNode root) {
        if (root == null) {
            return;
        }
        Predicate<MerkleNode> filter = node -> !node.isLeaf();
        root.treeIterator().setFilter(filter).forEachRemaining(node -> ((MerkleInternal)node).rebuild());
    }
}

