/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.file;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.state.file.codec.FileJsonCodec;
import com.hedera.hapi.node.state.file.codec.FileProtoCodec;
import com.hedera.hapi.node.state.file.schema.FileSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class File {
    public static final Codec<File> PROTOBUF = new FileProtoCodec();
    public static final JsonCodec<File> JSON = new FileJsonCodec();
    public static final File DEFAULT = File.newBuilder().build();
    @Nullable
    private final FileID fileId;
    private final long expirationSecond;
    @Nullable
    private final KeyList keys;
    @NonNull
    private final Bytes contents;
    @NonNull
    private final String memo;
    private final boolean deleted;
    private final long preSystemDeleteExpirationSecond;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public File(FileID fileId, long expirationSecond, KeyList keys, Bytes contents, String memo, boolean deleted, long preSystemDeleteExpirationSecond) {
        this.$unknownFields = null;
        this.fileId = fileId;
        this.expirationSecond = expirationSecond;
        this.keys = keys;
        this.contents = contents != null ? contents : Bytes.EMPTY;
        this.memo = memo != null ? memo : "";
        this.deleted = deleted;
        this.preSystemDeleteExpirationSecond = preSystemDeleteExpirationSecond;
    }

    public File(FileID fileId, long expirationSecond, KeyList keys, Bytes contents, String memo, boolean deleted, long preSystemDeleteExpirationSecond, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.fileId = fileId;
        this.expirationSecond = expirationSecond;
        this.keys = keys;
        this.contents = contents != null ? contents : Bytes.EMPTY;
        this.memo = memo != null ? memo : "";
        this.deleted = deleted;
        this.preSystemDeleteExpirationSecond = preSystemDeleteExpirationSecond;
    }

    public FileID fileId() {
        return this.fileId;
    }

    public long expirationSecond() {
        return this.expirationSecond;
    }

    public KeyList keys() {
        return this.keys;
    }

    public Bytes contents() {
        return this.contents;
    }

    public String memo() {
        return this.memo;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public long preSystemDeleteExpirationSecond() {
        return this.preSystemDeleteExpirationSecond;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileSchema.FILE_ID, (Object)this.fileId, FileID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)FileSchema.EXPIRATION_SECOND, (long)this.expirationSecond, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileSchema.KEYS, (Object)this.keys, KeyList.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)FileSchema.CONTENTS, (RandomAccessData)this.contents, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)FileSchema.MEMO, (String)this.memo, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)FileSchema.DELETED, (boolean)this.deleted, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)FileSchema.PRE_SYSTEM_DELETE_EXPIRATION_SECOND, (long)this.preSystemDeleteExpirationSecond, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.fileId != null && !this.fileId.equals(File.DEFAULT.fileId)) {
                result = 31 * result + this.fileId.hashCode();
            }
            if (this.expirationSecond != File.DEFAULT.expirationSecond) {
                result = 31 * result + Long.hashCode(this.expirationSecond);
            }
            if (this.keys != null && !this.keys.equals(File.DEFAULT.keys)) {
                result = 31 * result + this.keys.hashCode();
            }
            if (this.contents != null && !this.contents.equals((Object)File.DEFAULT.contents)) {
                result = 31 * result + this.contents.hashCode();
            }
            if (this.memo != null && !this.memo.equals(File.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.deleted != File.DEFAULT.deleted) {
                result = 31 * result + Boolean.hashCode(this.deleted);
            }
            if (this.preSystemDeleteExpirationSecond != File.DEFAULT.preSystemDeleteExpirationSecond) {
                result = 31 * result + Long.hashCode(this.preSystemDeleteExpirationSecond);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        File thatObj = (File)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.fileId == null && thatObj.fileId != null) {
            return false;
        }
        if (this.fileId != null && !this.fileId.equals(thatObj.fileId)) {
            return false;
        }
        if (this.expirationSecond != thatObj.expirationSecond) {
            return false;
        }
        if (this.keys == null && thatObj.keys != null) {
            return false;
        }
        if (this.keys != null && !this.keys.equals(thatObj.keys)) {
            return false;
        }
        if (this.contents == null && thatObj.contents != null) {
            return false;
        }
        if (this.contents != null && !this.contents.equals((Object)thatObj.contents)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.preSystemDeleteExpirationSecond != thatObj.preSystemDeleteExpirationSecond) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "File[fileId=" + String.valueOf(this.fileId) + ", expirationSecond=" + this.expirationSecond + ", keys=" + String.valueOf(this.keys) + ", contents=" + String.valueOf(this.contents) + ", memo=" + this.memo + ", deleted=" + this.deleted + ", preSystemDeleteExpirationSecond=" + this.preSystemDeleteExpirationSecond + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasFileId() {
        return this.fileId != null;
    }

    public FileID fileIdOrElse(@NonNull FileID defaultValue) {
        return this.hasFileId() ? this.fileId : defaultValue;
    }

    @NonNull
    public FileID fileIdOrThrow() {
        return Objects.requireNonNull(this.fileId, "Field fileId is null");
    }

    public void ifFileId(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileId()) {
            ifPresent.accept(this.fileId);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fileId, this.expirationSecond, this.keys, this.contents, this.memo, this.deleted, this.preSystemDeleteExpirationSecond, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private FileID fileId = null;
        private long expirationSecond = 0L;
        @Nullable
        private KeyList keys = null;
        @NonNull
        private Bytes contents = Bytes.EMPTY;
        @NonNull
        private String memo = "";
        private boolean deleted = false;
        private long preSystemDeleteExpirationSecond = 0L;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(FileID fileId, long expirationSecond, KeyList keys, Bytes contents, String memo, boolean deleted, long preSystemDeleteExpirationSecond) {
            this.$unknownFields = null;
            this.fileId = fileId;
            this.expirationSecond = expirationSecond;
            this.keys = keys;
            this.contents = contents != null ? contents : Bytes.EMPTY;
            this.memo = memo != null ? memo : "";
            this.deleted = deleted;
            this.preSystemDeleteExpirationSecond = preSystemDeleteExpirationSecond;
        }

        public Builder(FileID fileId, long expirationSecond, KeyList keys, Bytes contents, String memo, boolean deleted, long preSystemDeleteExpirationSecond, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.fileId = fileId;
            this.expirationSecond = expirationSecond;
            this.keys = keys;
            this.contents = contents != null ? contents : Bytes.EMPTY;
            this.memo = memo != null ? memo : "";
            this.deleted = deleted;
            this.preSystemDeleteExpirationSecond = preSystemDeleteExpirationSecond;
        }

        public File build() {
            return new File(this.fileId, this.expirationSecond, this.keys, this.contents, this.memo, this.deleted, this.preSystemDeleteExpirationSecond);
        }

        public Builder fileId(@Nullable FileID fileId) {
            this.fileId = fileId;
            return this;
        }

        public Builder fileId(FileID.Builder builder) {
            this.fileId = builder.build();
            return this;
        }

        public Builder expirationSecond(long expirationSecond) {
            this.expirationSecond = expirationSecond;
            return this;
        }

        public Builder keys(@Nullable KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder contents(@NonNull Bytes contents) {
            this.contents = contents != null ? contents : Bytes.EMPTY;
            return this;
        }

        public Builder memo(@NonNull String memo) {
            this.memo = memo != null ? memo : "";
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder preSystemDeleteExpirationSecond(long preSystemDeleteExpirationSecond) {
            this.preSystemDeleteExpirationSecond = preSystemDeleteExpirationSecond;
            return this;
        }
    }
}

