/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.utility.MerkleTreeVisualizer;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import picocli.CommandLine;

@CommandLine.Command(name="ls", mixinStandardHelpOptions=true, description={"Print information about nodes at this position in the state."})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorLs
extends StateEditorOperation {
    private String path = "";
    private int depth = 10;
    private boolean verbose = false;

    @CommandLine.Parameters(arity="0..1", description={"The route to show."})
    private void setPath(String path) {
        this.path = path;
    }

    @CommandLine.Option(names={"-d", "--depth"}, description={"The maximum depth to show, relative to the current working route."})
    private void setDepth(int depth) {
        this.depth = depth;
    }

    @CommandLine.Option(names={"-v", "--verbose"}, description={"Enable verbose mode, where we don't ignore nodes inside the map classes."})
    private void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void run() {
        MerkleNode node = this.getStateEditor().getRelativeNode(this.path);
        MerkleTreeVisualizer visualizer = new MerkleTreeVisualizer(node).setDepth(this.depth).setIgnoreDepthAnnotations(this.verbose).setHashLength(8).setUseColors(true);
        System.out.println("\n" + String.valueOf(visualizer));
    }
}

