/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.simulated.config;

import com.swirlds.platform.test.fixtures.simulated.Latency;
import com.swirlds.platform.test.fixtures.simulated.config.NodeConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;

public class NodeConfigBuilder {
    private Duration createEventEvery = Duration.ofMillis(20L);
    private Latency customLatency = new Latency(Duration.ZERO);
    private Duration intakeQueueDelay = Duration.ZERO;

    private NodeConfigBuilder() {
    }

    @NonNull
    public static NodeConfigBuilder builder() {
        return new NodeConfigBuilder();
    }

    @NonNull
    public static NodeConfigBuilder builder(@NonNull NodeConfig config) {
        NodeConfigBuilder builder = NodeConfigBuilder.builder();
        builder.setCustomLatency(config.customLatency());
        builder.setCreateEventEvery(config.createEventEvery());
        builder.setIntakeQueueDelay(config.intakeQueueDelay());
        return builder;
    }

    @NonNull
    public NodeConfigBuilder setCreateEventEvery(@NonNull Duration createEventEvery) {
        this.createEventEvery = Objects.requireNonNull(createEventEvery);
        return this;
    }

    @NonNull
    public NodeConfigBuilder setCustomLatency(@NonNull Latency customLatency) {
        this.customLatency = Objects.requireNonNull(customLatency);
        return this;
    }

    @NonNull
    public NodeConfigBuilder setIntakeQueueDelay(@NonNull Duration intakeQueueDelay) {
        this.intakeQueueDelay = Objects.requireNonNull(intakeQueueDelay);
        return this;
    }

    @NonNull
    public NodeConfig build() {
        return new NodeConfig(this.createEventEvery, this.customLatency, this.intakeQueueDelay);
    }
}

