/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.roster;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class SerializableX509Certificate
implements SelfSerializable {
    public static final int MAX_CERT_LENGTH = 8192;
    private static final long CLASS_ID = 2536215498740997255L;
    private X509Certificate certificate;

    public SerializableX509Certificate(@NonNull X509Certificate certificate) {
        this.certificate = Objects.requireNonNull(certificate);
    }

    public SerializableX509Certificate() {
    }

    @NonNull
    public X509Certificate getCertificate() {
        return Objects.requireNonNull(this.certificate);
    }

    public long getClassId() {
        return 2536215498740997255L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        try {
            byte[] encoded = this.certificate.getEncoded();
            out.writeByteArray(encoded);
        }
        catch (CertificateEncodingException e) {
            throw new IOException("Not able to serialize x509 certificate", e);
        }
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        byte[] encoded = in.readByteArray(8192);
        try {
            this.certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(encoded));
        }
        catch (CertificateException e) {
            throw new IOException("Not able to deserialize x509 certificate", e);
        }
    }

    @NonNull
    public PublicKey getPublicKey() {
        return Objects.requireNonNull(this.certificate.getPublicKey(), "PublicKey is null");
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

