/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.simulated.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import org.hiero.consensus.model.node.NodeId;

public class MapBuilder<T> {
    private final Map<NodeId, T> map = new HashMap<NodeId, T>();
    private T lastElement = null;
    private Long lastIndex = 0L;

    private MapBuilder() {
    }

    @NonNull
    public static <T> MapBuilder<T> builder(@NonNull Class<T> type) {
        return new MapBuilder<T>();
    }

    @NonNull
    public MapBuilder<T> useElement(@NonNull T e) {
        this.lastElement = e;
        return this;
    }

    @NonNull
    public MapBuilder<T> times(int num) {
        for (int i = 0; i < num; ++i) {
            Long l = this.lastIndex;
            this.lastIndex = this.lastIndex + 1L;
            this.map.put(NodeId.of((long)l), this.lastElement);
        }
        return this;
    }

    @NonNull
    public Map<NodeId, T> build() {
        if (this.map.isEmpty()) {
            Long l = this.lastIndex;
            this.lastIndex = this.lastIndex + 1L;
            this.map.put(NodeId.of((long)l), this.lastElement);
        }
        return this.map;
    }
}

