/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.consistency;

import com.swirlds.base.state.Startable;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.config.StoppableThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.platform.system.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.utility.ByteUtils;

public class TransactionGenerator
implements Startable {
    private final Random random;
    private final Platform platform;
    private final StoppableThread thread;

    public TransactionGenerator(@NonNull Random random, @NonNull Platform platform, int networkWideTransactionsPerSecond) {
        this.random = Objects.requireNonNull(random);
        this.platform = Objects.requireNonNull(platform);
        double tps = (double)networkWideTransactionsPerSecond / (double)platform.getRoster().rosterEntries().size();
        this.thread = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("consistency-testing-tool")).setThreadName("transaction-generator")).setMaximumRate(tps)).setWork(this::generateTransaction).build();
    }

    public void start() {
        this.thread.start();
    }

    private void generateTransaction() {
        this.platform.createTransaction(ByteUtils.longToByteArray((long)this.random.nextLong()));
    }
}

