/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery.internal;

import com.swirlds.common.io.IOIterator;
import com.swirlds.common.stream.RunningHashCalculatorForStream;
import com.swirlds.platform.recovery.internal.EventStreamMultiFileIterator;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.crypto.RunningHashable;
import org.hiero.consensus.model.event.CesEvent;

public class MultiFileRunningHashIterator
implements IOIterator<CesEvent> {
    private final EventStreamMultiFileIterator iterator;
    private final RunningHashCalculatorForStream<CesEvent> runningHashCalculator;

    public MultiFileRunningHashIterator(EventStreamMultiFileIterator iterator) {
        this.iterator = Objects.requireNonNull(iterator, "iterator must not be null");
        this.runningHashCalculator = new RunningHashCalculatorForStream();
        this.runningHashCalculator.setRunningHash(iterator.getStartHash());
        for (CesEvent skippedEvent : iterator.getSkippedEvents()) {
            this.runningHashCalculator.addObject((RunningHashable)skippedEvent);
        }
    }

    public boolean hasNext() throws IOException {
        return this.iterator.hasNext();
    }

    public CesEvent next() throws IOException {
        CesEvent next = this.iterator.next();
        this.runningHashCalculator.addObject((RunningHashable)next);
        return next;
    }

    public CesEvent peek() throws IOException {
        return this.iterator.peek();
    }

    public void close() {
        this.iterator.close();
    }

    public long getBytesRead() {
        return this.iterator.getBytesRead();
    }

    public long getDamagedFileCount() {
        return this.iterator.getDamagedFileCount();
    }
}

