/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.platform.message.codec;

import com.hedera.hapi.platform.message.GossipEventWindow;
import com.hedera.hapi.platform.message.GossipSyncData;
import com.hedera.hapi.platform.message.schema.GossipSyncDataSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GossipSyncDataJsonCodec
implements JsonCodec<GossipSyncData> {
    @NonNull
    public GossipSyncData parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            GossipEventWindow temp_window = null;
            List<Bytes> temp_tips = Collections.emptyList();
            block10: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "window": {
                        temp_window = (GossipEventWindow)GossipEventWindow.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block10;
                    }
                    case "tips": {
                        temp_tips = kvPair.value().arr().value().stream().map(v -> Bytes.fromBase64((String)v.STRING().getText())).toList();
                        continue block10;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new GossipSyncData(temp_window, temp_tips);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull GossipSyncData data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.window() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"window", GossipEventWindow.JSON, (Object)data.window()));
        }
        if (!data.tips().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"tips", (FieldDefinition)GossipSyncDataSchema.TIPS, data.tips()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

