/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.pool;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;
import org.hiero.consensus.config.TransactionConfig;
import org.hiero.consensus.event.creator.impl.TransactionSupplier;
import org.hiero.consensus.event.creator.impl.config.EventCreationConfig;
import org.hiero.consensus.event.creator.impl.pool.TransactionPoolMetrics;
import org.hiero.consensus.model.status.PlatformStatus;

public class TransactionPoolNexus
implements TransactionSupplier {
    private static final Logger logger = LogManager.getLogger(TransactionPoolNexus.class);
    private final RateLimitedLogger illegalTransactionLogger;
    private final Queue<Bytes> bufferedTransactions = new LinkedList<Bytes>();
    private final Queue<Bytes> priorityBufferedTransactions = new LinkedList<Bytes>();
    private int bufferedSignatureTransactionCount = 0;
    private final int maxTransactionBytesPerEvent;
    private final int throttleTransactionQueueSize;
    private final TransactionPoolMetrics transactionPoolMetrics;
    private final int maximumTransactionSize;
    private PlatformStatus platformStatus = PlatformStatus.STARTING_UP;
    private final Duration maximumPermissibleUnhealthyDuration;
    private boolean healthy = true;

    public TransactionPoolNexus(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time) {
        this.illegalTransactionLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(10L));
        TransactionConfig transactionConfig = (TransactionConfig)configuration.getConfigData(TransactionConfig.class);
        this.maxTransactionBytesPerEvent = transactionConfig.maxTransactionBytesPerEvent();
        this.throttleTransactionQueueSize = transactionConfig.throttleTransactionQueueSize();
        this.transactionPoolMetrics = new TransactionPoolMetrics(metrics, this::getBufferedTransactionCount, this::getPriorityBufferedTransactionCount);
        this.maximumTransactionSize = transactionConfig.transactionMaxBytes();
        EventCreationConfig eventCreationConfig = (EventCreationConfig)configuration.getConfigData(EventCreationConfig.class);
        this.maximumPermissibleUnhealthyDuration = eventCreationConfig.maximumPermissibleUnhealthyDuration();
    }

    public synchronized boolean submitApplicationTransaction(@NonNull Bytes appTransaction) {
        if (!this.healthy || this.platformStatus != PlatformStatus.ACTIVE) {
            return false;
        }
        if (appTransaction == null) {
            this.illegalTransactionLogger.error(LogMarker.EXCEPTION.getMarker(), "transaction is null", new Object[0]);
            return false;
        }
        if (appTransaction.length() > (long)this.maximumTransactionSize) {
            this.illegalTransactionLogger.error(LogMarker.EXCEPTION.getMarker(), "transaction has {} bytes, maximum permissible transaction size is {}", new Object[]{appTransaction.length(), this.maximumTransactionSize});
            return false;
        }
        return this.submitTransaction(appTransaction, false);
    }

    public synchronized boolean submitTransaction(@NonNull Bytes transaction, boolean priority) {
        Objects.requireNonNull(transaction);
        if (!priority && this.bufferedTransactions.size() + this.priorityBufferedTransactions.size() > this.throttleTransactionQueueSize) {
            this.transactionPoolMetrics.recordRejectedAppTransaction();
            return false;
        }
        if (priority) {
            ++this.bufferedSignatureTransactionCount;
            this.transactionPoolMetrics.recordSubmittedPlatformTransaction();
        } else {
            this.transactionPoolMetrics.recordAcceptedAppTransaction();
        }
        if (priority) {
            this.priorityBufferedTransactions.add(transaction);
        } else {
            this.bufferedTransactions.add(transaction);
        }
        return true;
    }

    public synchronized void updatePlatformStatus(@NonNull PlatformStatus platformStatus) {
        this.platformStatus = platformStatus;
    }

    public synchronized void reportUnhealthyDuration(@NonNull Duration duration) {
        this.healthy = CompareTo.isLessThan((Comparable)duration, (Object)this.maximumPermissibleUnhealthyDuration);
    }

    @Nullable
    private Bytes getNextTransaction(long currentEventSize) {
        long maxSize = (long)this.maxTransactionBytesPerEvent - currentEventSize;
        if (maxSize <= 0L) {
            return null;
        }
        if (!this.priorityBufferedTransactions.isEmpty() && this.priorityBufferedTransactions.peek().length() <= maxSize) {
            --this.bufferedSignatureTransactionCount;
            return this.priorityBufferedTransactions.poll();
        }
        if (!this.bufferedTransactions.isEmpty() && this.bufferedTransactions.peek().length() <= maxSize) {
            return this.bufferedTransactions.poll();
        }
        return null;
    }

    @Override
    @NonNull
    public synchronized List<Bytes> getTransactions() {
        Bytes transaction;
        if (this.bufferedTransactions.isEmpty() && this.priorityBufferedTransactions.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Bytes> selectedTrans = new LinkedList<Bytes>();
        long currEventSize = 0L;
        while ((transaction = this.getNextTransaction(currEventSize)) != null) {
            currEventSize += transaction.length();
            selectedTrans.add(transaction);
        }
        return selectedTrans;
    }

    public synchronized boolean hasBufferedSignatureTransactions() {
        return this.bufferedSignatureTransactionCount > 0;
    }

    private synchronized int getBufferedTransactionCount() {
        return this.bufferedTransactions.size();
    }

    private synchronized int getPriorityBufferedTransactionCount() {
        return this.priorityBufferedTransactions.size();
    }

    synchronized void clear() {
        this.bufferedTransactions.clear();
        this.priorityBufferedTransactions.clear();
        this.bufferedSignatureTransactionCount = 0;
    }
}

