/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.state.merkle.disk.OnDiskKey;
import com.swirlds.virtualmap.serialize.KeySerializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Objects;

public final class OnDiskKeySerializer<K>
implements KeySerializer<OnDiskKey<K>> {
    private static final int TYPICAL_SIZE = 256;
    @Deprecated(forRemoval=true)
    private static final long CLASS_ID = -7380775093914815470L;
    private static final int VERSION = 1;
    private final long serializerClassId;
    private final long keyClassId;
    private final Codec<K> codec;

    @Deprecated(forRemoval=true)
    public OnDiskKeySerializer() {
        this.serializerClassId = -7380775093914815470L;
        this.keyClassId = 0L;
        this.codec = null;
    }

    public OnDiskKeySerializer(long serializerClassId, long keyClassId, @Nullable Codec<K> codec) {
        this.serializerClassId = serializerClassId;
        this.keyClassId = keyClassId;
        this.codec = codec;
    }

    public long getClassId() {
        return this.serializerClassId;
    }

    public int getVersion() {
        return 1;
    }

    public long getCurrentDataVersion() {
        return 1L;
    }

    public int getSerializedSize() {
        return -1;
    }

    public int getSerializedSize(@NonNull OnDiskKey<K> key) {
        assert (this.codec != null);
        return this.codec.measureRecord(key.getKey());
    }

    public int getTypicalSerializedSize() {
        return 256;
    }

    public void serialize(@NonNull OnDiskKey<K> key, @NonNull WritableSequentialData out) {
        assert (this.codec != null);
        try {
            this.codec.write(key.getKey(), out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OnDiskKey<K> deserialize(@NonNull ReadableSequentialData in) {
        assert (this.codec != null);
        try {
            Object k = this.codec.parse(in);
            Objects.requireNonNull(k);
            return new OnDiskKey<Object>(this.keyClassId, this.codec, k);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(@NonNull BufferedData bufferedData, @NonNull OnDiskKey<K> keyToCompare) {
        assert (this.codec != null);
        try {
            return this.codec.fastEquals(keyToCompare.getKey(), (ReadableSequentialData)bufferedData);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

