/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldSatisfyOnlyOnce
extends BasicErrorMessageFactory {
    private static final String NO_ELEMENT_SATISFIED_REQUIREMENTS = "%nExpecting exactly one element of actual:%n  %s%nto satisfy the requirements but none did";
    private static final String MORE_THAN_ONE_ELEMENT_SATISFIED_REQUIREMENTS = "%nExpecting exactly one element of actual:%n  %s%nto satisfy the requirements but these %s elements did:%n  %s";

    public static <E> ErrorMessageFactory shouldSatisfyOnlyOnce(Iterable<? extends E> actual, List<? extends E> satisfiedElements) {
        return satisfiedElements.isEmpty() ? new ShouldSatisfyOnlyOnce(actual) : new ShouldSatisfyOnlyOnce(actual, satisfiedElements);
    }

    private ShouldSatisfyOnlyOnce(Iterable<?> actual) {
        super(NO_ELEMENT_SATISFIED_REQUIREMENTS, actual);
    }

    private ShouldSatisfyOnlyOnce(Iterable<?> actual, List<?> satisfiedElements) {
        super(MORE_THAN_ONE_ELEMENT_SATISFIED_REQUIREMENTS, actual, satisfiedElements.size(), satisfiedElements);
    }
}

