/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.engine;

import com.goterl.lazysodium.LazySodiumJava;
import com.goterl.lazysodium.SodiumJava;
import com.goterl.lazysodium.interfaces.Sign;
import com.swirlds.logging.legacy.LogMarker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.TransactionSignature;
import org.hiero.base.crypto.engine.OperationProvider;
import org.hiero.base.utility.CommonUtils;

public class Ed25519VerificationProvider
extends OperationProvider<TransactionSignature, Void, Boolean, Sign.Native, SignatureType> {
    private static final Logger logger = LogManager.getLogger(Ed25519VerificationProvider.class);
    private static final Sign.Native algorithm;

    @Override
    protected boolean compute(byte[] message, byte[] signature, byte[] publicKey) {
        return this.compute(message, signature, publicKey, SignatureType.ED25519);
    }

    protected boolean compute(byte[] message, byte[] signature, byte[] publicKey, SignatureType algorithmType) {
        Sign.Native loadedAlgorithm = this.loadAlgorithm(algorithmType);
        return this.compute(loadedAlgorithm, algorithmType, message, signature, publicKey);
    }

    @Override
    protected Sign.Native loadAlgorithm(SignatureType algorithmType) {
        return algorithm;
    }

    @Override
    protected Boolean handleItem(Sign.Native algorithm, SignatureType algorithmType, TransactionSignature sig, Void optionalData) {
        return this.compute(algorithm, algorithmType, sig.getMessage().toByteArray(), sig.getSignature().toByteArray(), sig.getPublicKey().toByteArray());
    }

    private boolean compute(Sign.Native algorithm, SignatureType algorithmType, byte[] message, byte[] signature, byte[] publicKey) {
        boolean isValid = algorithm.cryptoSignVerifyDetached(signature, message, message.length, publicKey);
        if (!isValid && logger.isDebugEnabled()) {
            logger.debug(LogMarker.TESTING_EXCEPTIONS.getMarker(), "Adv Crypto Subsystem: Signature Verification Failure for signature type {} [ publicKey = {}, signature = {} ]", (Object)algorithmType, (Object)CommonUtils.hex((byte[])publicKey), (Object)CommonUtils.hex((byte[])signature));
        }
        return isValid;
    }

    static {
        SodiumJava sodiumJava = new SodiumJava();
        algorithm = new LazySodiumJava(sodiumJava);
    }
}

