/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.disk.OnDiskSingletonHelper;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.spi.ReadableSingletonStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class OnDiskReadableSingletonState<T>
extends ReadableSingletonStateBase<T> {
    @NonNull
    private final VirtualMap virtualMap;

    public OnDiskReadableSingletonState(@NonNull String serviceName, @NonNull String stateKey, @NonNull VirtualMap virtualMap) {
        super(serviceName, stateKey);
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    protected T readFromDataSource() {
        Object value = OnDiskSingletonHelper.getFromStore(this.serviceName, this.stateKey, this.virtualMap);
        StateLogger.logSingletonRead(StateUtils.computeLabel(this.serviceName, this.stateKey), value);
        return value;
    }
}

