/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.nft;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.demo.platform.nft.NftId;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class Nft
extends PartialMerkleLeaf
implements Keyed<NftId>,
MerkleLeaf {
    private static final long CLASS_ID = -8225049841700058417L;
    private static final int DATA_STRING_LIMIT = 1000000;
    private static final int VERSION_ORIGINAL = 1;
    private long shardNum;
    private long realmNum;
    private long tokenNum;
    private MapKey mapKey;
    private String serialNumber;
    private String memo;

    public Nft() {
        this.mapKey = new MapKey();
    }

    private Nft(Nft nft) {
        super((PartialMerkleLeaf)nft);
        this.setShardNum(nft.getShardNum());
        this.setRealmNum(nft.getRealmNum());
        this.setTokenNum(nft.getTokenNum());
        this.setMapKey(nft.getMapKey().copy());
        this.setMemo(nft.getMemo());
        this.setSerialNumber(nft.getSerialNumber());
        nft.setImmutable(true);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.shardNum);
        out.writeLong(this.realmNum);
        out.writeLong(this.tokenNum);
        this.mapKey.serialize(out);
        out.writeNormalisedString(this.serialNumber);
        out.writeNormalisedString(this.memo);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.shardNum = in.readLong();
        this.realmNum = in.readLong();
        this.tokenNum = in.readLong();
        this.mapKey.deserialize(in, this.mapKey.getVersion());
        this.serialNumber = in.readNormalisedString(1000000);
        this.memo = in.readNormalisedString(1000000);
    }

    public long getClassId() {
        return -8225049841700058417L;
    }

    public int getVersion() {
        return 1;
    }

    public Nft copy() {
        return new Nft(this);
    }

    public Nft deepCopy() {
        Nft nft = new Nft();
        nft.setShardNum(this.getShardNum());
        nft.setRealmNum(this.getRealmNum());
        nft.setTokenNum(this.getTokenNum());
        nft.setMemo(this.getMemo());
        nft.setSerialNumber(this.getSerialNumber());
        nft.setMapKey(this.getMapKey().copy());
        return nft;
    }

    public long getShardNum() {
        return this.shardNum;
    }

    public void setShardNum(long shardNum) {
        this.shardNum = shardNum;
    }

    public long getRealmNum() {
        return this.realmNum;
    }

    public void setRealmNum(long realmNum) {
        this.realmNum = realmNum;
    }

    public long getTokenNum() {
        return this.tokenNum;
    }

    public void setTokenNum(long tokenNum) {
        this.tokenNum = tokenNum;
    }

    public void setMapKey(MapKey mapKey) {
        this.mapKey = mapKey;
    }

    public MapKey getMapKey() {
        return this.mapKey;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public int hashCode() {
        return Objects.hash(this.shardNum, this.realmNum, this.tokenNum);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        Nft nft = (Nft)((Object)other);
        return this.shardNum == nft.shardNum && this.realmNum == nft.realmNum && this.tokenNum == nft.tokenNum && Objects.equals(this.mapKey, nft.mapKey) && Objects.equals(this.serialNumber, nft.serialNumber) && Objects.equals(this.memo, nft.memo);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("shardNum", (Object)this.getShardNum()).append("realmNum", (Object)this.getRealmNum()).append("tokenNum", (Object)this.getTokenNum()).append("owner", (Object)this.getMapKey()).append("memo", (Object)this.getMemo()).append("serialNumber", (Object)this.getSerialNumber()).toString();
    }

    public NftId getKey() {
        return new NftId(this.shardNum, this.realmNum, this.tokenNum);
    }

    public void setKey(NftId key) {
        this.shardNum = key.getShardNum();
        this.realmNum = key.getRealmNum();
        this.tokenNum = key.getTokenNum();
    }
}

