/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.validators;

import com.swirlds.config.api.validation.ConfigPropertyConstraint;
import com.swirlds.config.api.validation.ConfigViolation;
import com.swirlds.config.api.validation.PropertyMetadata;
import com.swirlds.config.impl.internal.ConfigNumberUtils;
import com.swirlds.config.impl.validators.DefaultConfigViolation;
import java.util.Objects;

public class MinConstraint<T extends Number>
implements ConfigPropertyConstraint<T> {
    private final T min;

    public MinConstraint(T min) {
        this.min = min;
    }

    public ConfigViolation check(PropertyMetadata<T> metadata) {
        Objects.requireNonNull(metadata, "metadata must not be null");
        if (!metadata.exists()) {
            String message = "Property '" + metadata.getName() + "' must be defined";
            return DefaultConfigViolation.of(metadata, message);
        }
        if (metadata.getRawValue() == null) {
            String message = "Property '" + metadata.getName() + "' must not be null.";
            return DefaultConfigViolation.of(metadata, message);
        }
        Number convertedValue = (Number)metadata.getConverter().convert(metadata.getRawValue());
        if (ConfigNumberUtils.compare(convertedValue, metadata.getValueType(), this.min) < 0) {
            String message = "Value of Property '" + metadata.getName() + "' must be >= '" + String.valueOf(this.min) + "'";
            return DefaultConfigViolation.of(metadata, message);
        }
        return null;
    }
}

