/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import org.hiero.base.CompareTo;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;

public class PlatformHealthRule
implements EventCreationRule {
    private final Duration maximumPermissibleUnhealthyDuration;
    private final Supplier<Duration> currentUnhealthyDurationSupplier;

    public PlatformHealthRule(@NonNull Duration maximumPermissibleUnhealthyDuration, @NonNull Supplier<Duration> currentUnhealthyDurationSupplier) {
        this.maximumPermissibleUnhealthyDuration = Objects.requireNonNull(maximumPermissibleUnhealthyDuration);
        this.currentUnhealthyDurationSupplier = Objects.requireNonNull(currentUnhealthyDurationSupplier);
    }

    @Override
    public boolean isEventCreationPermitted() {
        return CompareTo.isLessThanOrEqualTo((Comparable)this.currentUnhealthyDurationSupplier.get(), (Object)this.maximumPermissibleUnhealthyDuration);
    }

    @Override
    public void eventWasCreated() {
    }

    @Override
    @NonNull
    public EventCreationStatus getEventCreationStatus() {
        return EventCreationStatus.OVERLOADED;
    }
}

