/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

public enum CountingVote {
    YES_MAJORITY(true, true),
    YES_MINORITY(true, false),
    NO_MAJORITY(false, true),
    NO_MINORITY(false, false);

    private final boolean vote;
    private final boolean supermajority;

    private CountingVote(boolean vote, boolean supermajority) {
        this.vote = vote;
        this.supermajority = supermajority;
    }

    public static CountingVote get(boolean vote, boolean supermajority) {
        if (vote) {
            if (supermajority) {
                return YES_MAJORITY;
            }
            return YES_MINORITY;
        }
        if (supermajority) {
            return NO_MAJORITY;
        }
        return NO_MINORITY;
    }

    public boolean getVote() {
        return this.vote;
    }

    public boolean isSupermajority() {
        return this.supermajority;
    }
}

