/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import java.util.concurrent.TimeUnit;

public class JVMPauseDetectorThread
extends Thread {
    private static final boolean ALLOCATE_OBJECTS = true;
    public volatile Long lastSleepTimeObj;
    private final JvmPauseCallback callback;
    private final int sleepMs;
    private volatile boolean doRun = true;

    public JVMPauseDetectorThread(JvmPauseCallback callback, int sleepMs) {
        super("jvm-pause-detector-thread");
        this.callback = callback;
        this.sleepMs = sleepMs;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long sleepNs = (long)this.sleepMs * 1000000L;
        try {
            long shortestObservedDeltaTimeNs = Long.MAX_VALUE;
            long timeBeforeMeasurement = Long.MAX_VALUE;
            long allocateStartNs = Long.MAX_VALUE;
            long allocateEndNs = Long.MAX_VALUE;
            while (this.doRun) {
                TimeUnit.NANOSECONDS.sleep(sleepNs);
                allocateStartNs = System.nanoTime();
                this.lastSleepTimeObj = timeBeforeMeasurement;
                allocateEndNs = System.nanoTime();
                long timeAfterMeasurement = System.nanoTime();
                long deltaTimeNs = timeAfterMeasurement - timeBeforeMeasurement;
                timeBeforeMeasurement = timeAfterMeasurement;
                if (deltaTimeNs < 0L) continue;
                if (deltaTimeNs < shortestObservedDeltaTimeNs) {
                    shortestObservedDeltaTimeNs = deltaTimeNs;
                }
                long pauseTimeNs = deltaTimeNs - shortestObservedDeltaTimeNs;
                this.callback.pauseInfo(pauseTimeNs / 1000000L, (allocateEndNs - allocateStartNs) / 1000000L);
            }
        }
        catch (InterruptedException e) {
            System.err.println("JVMPauseDetectorThread terminating...");
            Thread.currentThread().interrupt();
        }
    }

    public void terminate() {
        this.doRun = false;
    }

    @FunctionalInterface
    public static interface JvmPauseCallback {
        public void pauseInfo(long var1, long var3);
    }
}

