/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.virtualmap.VirtualValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class OnDiskValue<V>
implements VirtualValue {
    @Deprecated(forRemoval=true)
    private static final long CLASS_ID = 2396348118885234L;
    static final int VERSION = 1;
    private final long classId;
    private final Codec<V> codec;
    private V value;
    private boolean immutable = false;

    public OnDiskValue() {
        this.codec = null;
        this.classId = 2396348118885234L;
    }

    public OnDiskValue(long classId, @NonNull Codec<V> codec) {
        this.codec = Objects.requireNonNull(codec);
        this.classId = classId;
    }

    public OnDiskValue(long classId, @NonNull Codec<V> codec, @NonNull V value) {
        this(classId, codec);
        this.value = Objects.requireNonNull(value);
    }

    public VirtualValue copy() {
        OnDiskValue<V> copy = new OnDiskValue<V>(this.classId, Objects.requireNonNull(this.codec), this.value);
        this.immutable = true;
        return copy;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public VirtualValue asReadOnly() {
        if (this.isImmutable()) {
            return this;
        }
        OnDiskValue<V> copy = new OnDiskValue<V>(this.classId, Objects.requireNonNull(this.codec), this.value);
        copy.immutable = true;
        return copy;
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        if (this.codec == null) {
            throw new IllegalStateException("Cannot serialize on-disk value, null metadata / codec");
        }
        StateUtils.writeToStream((OutputStream)out, this.codec, this.value);
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int ignored) throws IOException {
        if (this.codec == null) {
            throw new IllegalStateException("Cannot deserialize on-disk value, null metadata / codec");
        }
        this.value = StateUtils.readFromStream((InputStream)in, this.codec);
    }

    public long getClassId() {
        return this.classId;
    }

    public int getVersion() {
        return 1;
    }

    @Nullable
    public V getValue() {
        return this.value;
    }

    public void setValue(@Nullable V value) {
        this.throwIfImmutable();
        this.value = Objects.requireNonNull(value);
    }
}

