/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.comparator.primitive.IntComparator;
import org.eclipse.collections.api.block.function.primitive.BooleanIntToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteIntToByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharIntToCharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleIntToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatIntToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntIntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.IntToByteFunction;
import org.eclipse.collections.api.block.function.primitive.IntToCharFunction;
import org.eclipse.collections.api.block.function.primitive.IntToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.IntToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToLongFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToShortFunction;
import org.eclipse.collections.api.block.function.primitive.LongIntToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortIntToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;

public interface IntIterable
extends PrimitiveIterable {
    public IntIterator intIterator();

    public int[] toArray();

    default public int[] toArray(int[] target) {
        return this.toList().toArray(target);
    }

    public boolean contains(int var1);

    default public boolean containsAll(int ... source) {
        if (this.size() <= 32 || source.length < 4) {
            for (int item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }
        IntSet set = this instanceof IntSet ? (IntSet)this : this.toSet();
        for (int item : source) {
            if (set.contains(item)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(IntIterable source) {
        if (this.size() <= 32 || source.size() < 4) {
            return source.allSatisfy(this::contains);
        }
        IntSet set = this instanceof IntSet ? (IntSet)this : this.toSet();
        return source.allSatisfy(set::contains);
    }

    default public boolean containsAny(int ... source) {
        IntIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof IntSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAny(IntIterable source) {
        IntIterable outside = this;
        IntIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof IntSet) {
            IntIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof IntSet)) {
            inside = inside.toSet();
        }
        return outside.anySatisfy(inside::contains);
    }

    default public boolean containsNone(int ... source) {
        IntIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof IntSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return false;
        }
        return true;
    }

    default public boolean containsNone(IntIterable source) {
        IntIterable outside = this;
        IntIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof IntSet) {
            IntIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof IntSet)) {
            inside = inside.toSet();
        }
        return outside.noneSatisfy(inside::contains);
    }

    default public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure var1);

    default public IntIterable tap(IntProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public IntIterable select(IntPredicate var1);

    public IntIterable reject(IntPredicate var1);

    default public <R extends MutableIntCollection> R select(IntPredicate predicate, R target) {
        this.each(each -> {
            if (predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    default public <R extends MutableIntCollection> R reject(IntPredicate predicate, R target) {
        this.each(each -> {
            if (!predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(IntToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(IntToObjectFunction<? extends V> function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(IntToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each -> {
            Iterable iterable = (Iterable)function.valueOf(each);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(IntToBooleanFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(IntToByteFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(IntToCharFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(IntToShortFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(IntToIntFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(IntToFloatFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(IntToLongFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(IntToDoubleFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    public int detectIfNone(IntPredicate var1, int var2);

    public int count(IntPredicate var1);

    public boolean anySatisfy(IntPredicate var1);

    public boolean allSatisfy(IntPredicate var1);

    default public boolean noneSatisfy(IntPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public MutableIntList toList();

    public MutableIntSet toSet();

    public MutableIntBag toBag();

    public LazyIntIterable asLazy();

    public <T> T injectInto(T var1, ObjectIntToObjectFunction<? super T, ? extends T> var2);

    default public boolean injectIntoBoolean(boolean injectedValue, BooleanIntToBooleanFunction function) {
        boolean[] result = new boolean[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public byte injectIntoByte(byte injectedValue, ByteIntToByteFunction function) {
        byte[] result = new byte[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public char injectIntoChar(char injectedValue, CharIntToCharFunction function) {
        char[] result = new char[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public short injectIntoShort(short injectedValue, ShortIntToShortFunction function) {
        short[] result = new short[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public int injectIntoInt(int injectedValue, IntIntToIntFunction function) {
        int[] result = new int[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public float injectIntoFloat(float injectedValue, FloatIntToFloatFunction function) {
        float[] result = new float[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public long injectIntoLong(long injectedValue, LongIntToLongFunction function) {
        long[] result = new long[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public double injectIntoDouble(double injectedValue, DoubleIntToDoubleFunction function) {
        double[] result = new double[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public long reduceIfEmpty(LongIntToLongFunction accumulator, long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.reduce(accumulator);
    }

    default public long reduce(LongIntToLongFunction accumulator) {
        boolean[] seenOne = new boolean[1];
        long[] result = new long[1];
        this.each(each -> {
            if (seenOne[0]) {
                result[0] = accumulator.valueOf(result[0], each);
            } else {
                seenOne[0] = true;
                result[0] = each;
            }
        });
        if (!seenOne[0]) {
            throw new NoSuchElementException();
        }
        return result[0];
    }

    default public RichIterable<IntIterable> chunk(int size) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public long sum();

    default public IntSummaryStatistics summaryStatistics() {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    public int max();

    public int maxIfEmpty(int var1);

    public int min();

    public int minIfEmpty(int var1);

    public double average();

    default public double averageIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.average();
    }

    public double median();

    default public double medianIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.median();
    }

    public int[] toSortedArray();

    public MutableIntList toSortedList();

    default public MutableIntList toSortedList(IntComparator comparator) {
        return this.toList().sortThis(comparator);
    }

    default public <T> MutableIntList toSortedListBy(IntToObjectFunction<T> function) {
        return this.toList().sortThisBy(function);
    }

    default public <T> MutableIntList toSortedListBy(IntToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.toList().sortThisBy(function, comparator);
    }
}

