/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.impl.PartialNaryMerkleInternal;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.common.merkle.utility.MerkleLong;
import com.swirlds.common.test.fixtures.merkle.TestMerkleCryptoFactory;
import com.swirlds.demo.platform.expiration.ExpirationRecordEntry;
import com.swirlds.demo.platform.expiration.ExpirationUtils;
import com.swirlds.fcqueue.FCQueue;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.merkle.test.fixtures.map.pta.MapValue;
import com.swirlds.merkle.test.fixtures.map.pta.MerkleMapKey;
import com.swirlds.merkle.test.fixtures.map.pta.TransactionRecord;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.SerializableHashable;

public class MapValueFCQ<T extends FastCopyable & SerializableHashable>
extends PartialNaryMerkleInternal
implements Keyed<MapKey>,
MapValue,
MerkleInternal {
    private static final long CLASS_ID = -1348359415997370947L;

    public MapValueFCQ(long balance, FCQueue<T> records) {
        this.setBalance(new MerkleLong(balance));
        this.setRecords(records);
    }

    private MapValueFCQ(MapValueFCQ<T> sourceValue) {
        this.setBalance(new MerkleLong(sourceValue.getBalanceValue()));
        this.setRecords(sourceValue.getRecords().copy());
        this.setKey(sourceValue.getKey());
        this.setImmutable(false);
        sourceValue.setImmutable(true);
    }

    public MapValueFCQ() {
        this.setRecords(new FCQueue());
        this.setBalance(new MerkleLong());
    }

    public static MapValueFCQBuilder newBuilder() {
        return new MapValueFCQBuilder();
    }

    public boolean childHasExpectedType(int index, long childClassId) {
        switch (index) {
            case 0: {
                return childClassId == 5101867068740213836L;
            }
            case 1: {
                return childClassId == 139236190103L;
            }
            case 2: {
                return childClassId == 7421730368676334687L;
            }
        }
        throw new IllegalChildIndexException(this.getMinimumChildCount(), this.getMaximumChildCount(), index);
    }

    public MerkleLong getBalance() {
        return (MerkleLong)this.getChild(0);
    }

    public void setBalance(MerkleLong balance) {
        this.setChild(0, (MerkleNode)balance);
    }

    public FCQueue<T> getRecords() {
        return (FCQueue)this.getChild(1);
    }

    public void setRecords(FCQueue<T> records) {
        this.setChild(1, (MerkleNode)records);
    }

    public MapKey getKey() {
        MerkleMapKey merkleMapKey = (MerkleMapKey)this.getChild(2);
        if (merkleMapKey == null) {
            return null;
        }
        return merkleMapKey.getMapKey();
    }

    public void setKey(MapKey key) {
        this.setChild(2, (MerkleNode)new MerkleMapKey(key));
    }

    public Hash calculateHash() {
        if (this.getHash() != null) {
            return this.getHash();
        }
        return TestMerkleCryptoFactory.getInstance().digestTreeSync((MerkleNode)this);
    }

    public long getBalanceValue() {
        return this.getBalance().getValue();
    }

    public int getRecordsSize() {
        return this.getRecords().size();
    }

    public MapValueFCQ<T> deleteFirst() {
        FCQueue<T> newRecords = this.getRecords();
        newRecords.poll();
        return this;
    }

    public MapValueFCQ<T> transferFrom(long balance, byte[] content, MapKey mapKey, long expirationTime, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        long newBalance = this.getBalanceValue() - balance;
        TransactionRecord newFromTransactionRecord = new TransactionRecord((long)this.getRecords().size(), balance, content, expirationTime);
        return this.addRecord(newBalance, newFromTransactionRecord, mapKey, expirationQueue, accountsWithExpiringRecords);
    }

    public MapValueFCQ<T> transferTo(long balance, byte[] content, MapKey mapKey, long expirationTime, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        long newBalance = this.getBalance().getValue() + balance;
        TransactionRecord newFromTransactionRecord = new TransactionRecord((long)this.getRecords().size(), balance, content, expirationTime);
        return this.addRecord(newBalance, newFromTransactionRecord, mapKey, expirationQueue, accountsWithExpiringRecords);
    }

    public MapValueFCQ<T> addRecord(long newBalance, T record, MapKey mapKey, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        FCQueue<T> newRecords = this.getRecords();
        newRecords.add(record);
        this.setBalance(new MerkleLong(newBalance));
        ExpirationUtils.addRecordToExpirationQueue((TransactionRecord)record, mapKey, expirationQueue, accountsWithExpiringRecords);
        return this;
    }

    public MapValueFCQ<T> addRecords(long newBalance, Collection<T> records, MapKey mapKey, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        this.getRecords().addAll(records);
        for (FastCopyable record : records) {
            ExpirationUtils.addRecordToExpirationQueue((TransactionRecord)record, mapKey, expirationQueue, accountsWithExpiringRecords);
        }
        this.setBalance(new MerkleLong(newBalance));
        return this;
    }

    public MapValueFCQ<T> copy() {
        this.throwIfImmutable();
        return new MapValueFCQ<T>(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MapValueFCQ that = (MapValueFCQ)((Object)o);
        return this.getBalance() == that.getBalance() && this.getRecords().equals(that.getRecords());
    }

    public int hashCode() {
        return Objects.hash(this.getBalance(), this.getRecords());
    }

    public String toString() {
        return "MapValueFCQ{balance=" + String.valueOf(this.getBalance()) + ", records=" + String.valueOf(this.getRecords()) + "}";
    }

    public long getClassId() {
        return -1348359415997370947L;
    }

    public int getVersion() {
        return 1;
    }

    public static class MapValueFCQBuilder<T extends MapValueFCQBuilder<T>> {
        private long index;
        private long balance;
        private byte[] content;
        private MapKey mapKey;
        private long expirationTime;
        private BlockingQueue<ExpirationRecordEntry> expirationQueue;
        private Set<MapKey> accountsWithExpiringRecords;

        MapValueFCQBuilder() {
        }

        public MapValueFCQBuilder setBalance(long balance) {
            this.balance = balance;
            return this;
        }

        public MapValueFCQBuilder setIndex(long index) {
            this.index = index;
            return this;
        }

        public MapValueFCQBuilder setContent(byte[] content) {
            this.content = content;
            return this;
        }

        public MapValueFCQBuilder setMapKey(MapKey mapKey) {
            this.mapKey = mapKey;
            return this;
        }

        public MapValueFCQBuilder setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public MapValueFCQBuilder setExpirationQueue(BlockingQueue<ExpirationRecordEntry> expirationQueue) {
            this.expirationQueue = expirationQueue;
            return this;
        }

        public MapValueFCQBuilder setAccountsWithExpiringRecords(Set<MapKey> accountsWithExpiringRecords) {
            this.accountsWithExpiringRecords = accountsWithExpiringRecords;
            return this;
        }

        public MapValueFCQ<TransactionRecord> build() {
            TransactionRecord record = new TransactionRecord(this.index, this.balance, this.content, this.expirationTime);
            FCQueue records = new FCQueue();
            records.add((FastCopyable)record);
            ExpirationUtils.addRecordToExpirationQueue(record, this.mapKey, this.expirationQueue, this.accountsWithExpiringRecords);
            return new MapValueFCQ<TransactionRecord>(record.getBalance(), records);
        }
    }

    private static class ChildIndices {
        public static final int BALANCE = 0;
        public static final int RECORDS = 1;
        public static final int KEY = 2;
        public static final int CHILD_COUNT = 3;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

