/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.HapiUtils;
import com.swirlds.state.lifecycle.StartupNetworks;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;

public interface MigrationContext {
    public long roundNumber();

    @NonNull
    public ReadableStates previousStates();

    @NonNull
    public WritableStates newStates();

    @NonNull
    public Configuration appConfig();

    @NonNull
    public Configuration platformConfig();

    @NonNull
    public StartupNetworks startupNetworks();

    public void copyAndReleaseOnDiskState(String var1);

    @Nullable
    public SemanticVersion previousVersion();

    public Map<String, Object> sharedValues();

    default public boolean isGenesis() {
        return this.previousVersion() == null || this.previousVersion() == SemanticVersion.DEFAULT;
    }

    default public <T extends Comparable<? super T>> boolean isUpgrade(@NonNull SemanticVersion currentVersion) {
        return HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(currentVersion, this.previousVersion()) > 0;
    }
}

