/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.platform.state.codec;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class PlatformStateJsonCodec
implements JsonCodec<PlatformState> {
    @NonNull
    public PlatformState parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            SemanticVersion temp_creation_software_version = null;
            int temp_rounds_non_ancient = 0;
            ConsensusSnapshot temp_consensus_snapshot = null;
            Timestamp temp_freeze_time = null;
            Timestamp temp_last_frozen_time = null;
            long temp_latest_freeze_round = 0L;
            Bytes temp_legacy_running_event_hash = Bytes.EMPTY;
            block20: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "creationSoftwareVersion": {
                        temp_creation_software_version = (SemanticVersion)SemanticVersion.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block20;
                    }
                    case "roundsNonAncient": {
                        temp_rounds_non_ancient = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                    case "consensusSnapshot": {
                        temp_consensus_snapshot = (ConsensusSnapshot)ConsensusSnapshot.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block20;
                    }
                    case "freezeTime": {
                        temp_freeze_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block20;
                    }
                    case "lastFrozenTime": {
                        temp_last_frozen_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block20;
                    }
                    case "latestFreezeRound": {
                        temp_latest_freeze_round = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                    case "legacyRunningEventHash": {
                        temp_legacy_running_event_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block20;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new PlatformState(temp_creation_software_version, temp_rounds_non_ancient, temp_consensus_snapshot, temp_freeze_time, temp_last_frozen_time, temp_latest_freeze_round, temp_legacy_running_event_hash);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull PlatformState data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.creationSoftwareVersion() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"creationSoftwareVersion", SemanticVersion.JSON, (Object)data.creationSoftwareVersion()));
        }
        if (data.roundsNonAncient() != 0) {
            fieldLines.add(JsonTools.field((String)"roundsNonAncient", (int)data.roundsNonAncient()));
        }
        if (data.consensusSnapshot() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"consensusSnapshot", ConsensusSnapshot.JSON, (Object)data.consensusSnapshot()));
        }
        if (data.freezeTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"freezeTime", Timestamp.JSON, (Object)data.freezeTime()));
        }
        if (data.lastFrozenTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"lastFrozenTime", Timestamp.JSON, (Object)data.lastFrozenTime()));
        }
        if (data.latestFreezeRound() != 0L) {
            fieldLines.add(JsonTools.field((String)"latestFreezeRound", (long)data.latestFreezeRound()));
        }
        if (data.legacyRunningEventHash() != Bytes.EMPTY && data.legacyRunningEventHash() != null && data.legacyRunningEventHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"legacyRunningEventHash", (Bytes)data.legacyRunningEventHash()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

