/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.hapi.block.stream.output.StateIdentifier;
import com.hedera.hapi.platform.state.QueueState;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.hapi.platform.state.StateKey;
import com.hedera.hapi.platform.state.StateValue;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.base.utility.Pair;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.disk.OnDiskKey;
import com.swirlds.state.merkle.disk.OnDiskKeySerializer;
import com.swirlds.state.merkle.disk.OnDiskValue;
import com.swirlds.state.merkle.disk.OnDiskValueSerializer;
import com.swirlds.state.merkle.memory.InMemoryValue;
import com.swirlds.state.merkle.queue.QueueNode;
import com.swirlds.state.merkle.singleton.SingletonNode;
import com.swirlds.state.merkle.singleton.StringLeaf;
import com.swirlds.state.merkle.singleton.ValueLeaf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;

public final class StateUtils {
    private static final int UNKNOWN_STATE_ID = -1;
    private static final IntFunction<String> UPGRADE_DATA_FILE_FORMAT = n -> String.format("UPGRADE_DATA\\[FileID\\[shardNum=\\d+, realmNum=\\d+, fileNum=%s]]", n);
    private static final Bytes[] VIRTUAL_MAP_KEY_CACHE = new Bytes[65536];
    private static final Map<String, String> LABEL_CACHE = new ConcurrentHashMap<String, String>();

    private StateUtils() {
    }

    public static <T> int writeToStream(@NonNull OutputStream out, @NonNull Codec<T> codec, @Nullable T object) throws IOException {
        WritableStreamingData stream = new WritableStreamingData(out);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        codec.write(object, (WritableSequentialData)new WritableStreamingData((OutputStream)byteStream));
        stream.writeInt(byteStream.size());
        stream.writeBytes(byteStream.toByteArray());
        return byteStream.size();
    }

    @Nullable
    public static <T> T readFromStream(@NonNull InputStream in, @NonNull Codec<T> codec) throws IOException {
        ReadableStreamingData stream = new ReadableStreamingData(in);
        int size = stream.readInt();
        stream.limit((long)size + 4L);
        try {
            return (T)codec.parse((ReadableSequentialData)stream);
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
    }

    @Deprecated
    public static void registerWithSystem(@NonNull StateMetadata md, @NonNull ConstructableRegistry constructableRegistry) {
        try {
            constructableRegistry.registerConstructable(new ClassConstructorPair(InMemoryValue.class, () -> new InMemoryValue(md.inMemoryValueClassId(), md.stateDefinition().keyCodec(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskKey.class, () -> new OnDiskKey(md.onDiskKeyClassId(), md.stateDefinition().keyCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskKeySerializer.class, () -> new OnDiskKeySerializer(md.onDiskKeySerializerClassId(), md.onDiskKeyClassId(), md.stateDefinition().keyCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskValue.class, () -> new OnDiskValue(md.onDiskValueClassId(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskValueSerializer.class, () -> new OnDiskValueSerializer(md.onDiskValueSerializerClassId(), md.onDiskValueClassId(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(SingletonNode.class, () -> new SingletonNode<Object>(md.serviceName(), md.stateDefinition().stateKey(), md.singletonClassId(), md.stateDefinition().valueCodec(), null)));
            constructableRegistry.registerConstructable(new ClassConstructorPair(QueueNode.class, () -> new QueueNode(md.serviceName(), md.stateDefinition().stateKey(), md.queueNodeClassId(), md.singletonClassId(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(StringLeaf.class, StringLeaf::new));
            constructableRegistry.registerConstructable(new ClassConstructorPair(ValueLeaf.class, () -> new ValueLeaf(md.singletonClassId(), md.stateDefinition().valueCodec())));
        }
        catch (ConstructableRegistryException e) {
            throw new IllegalStateException("Failed to register with the system '" + md.serviceName() + ":" + md.stateDefinition().stateKey() + "'", e);
        }
    }

    public static int stateIdFor(@NonNull String serviceName, @NonNull String stateKey) {
        int stateId;
        block20 : switch (serviceName) {
            case "AddressBookService": {
                int n;
                switch (stateKey) {
                    case "NODES": {
                        n = StateIdentifier.STATE_ID_NODES.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "BlockRecordService": {
                int n;
                switch (stateKey) {
                    case "BLOCKS": {
                        n = StateIdentifier.STATE_ID_BLOCK_INFO.protoOrdinal();
                        break block20;
                    }
                    case "RUNNING_HASHES": {
                        n = StateIdentifier.STATE_ID_RUNNING_HASHES.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "BlockStreamService": {
                int n;
                switch (stateKey) {
                    case "BLOCK_STREAM_INFO": {
                        n = StateIdentifier.STATE_ID_BLOCK_STREAM_INFO.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "CongestionThrottleService": {
                int n;
                switch (stateKey) {
                    case "CONGESTION_LEVEL_STARTS": {
                        n = StateIdentifier.STATE_ID_CONGESTION_STARTS.protoOrdinal();
                        break block20;
                    }
                    case "THROTTLE_USAGE_SNAPSHOTS": {
                        n = StateIdentifier.STATE_ID_THROTTLE_USAGE.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "ConsensusService": {
                int n;
                switch (stateKey) {
                    case "TOPICS": {
                        n = StateIdentifier.STATE_ID_TOPICS.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "ContractService": {
                int n;
                switch (stateKey) {
                    case "BYTECODE": {
                        n = StateIdentifier.STATE_ID_CONTRACT_BYTECODE.protoOrdinal();
                        break block20;
                    }
                    case "STORAGE": {
                        n = StateIdentifier.STATE_ID_CONTRACT_STORAGE.protoOrdinal();
                        break block20;
                    }
                    case "EVM_HOOK_STATES": {
                        n = StateIdentifier.STATE_ID_EVM_HOOK_STATES.protoOrdinal();
                        break block20;
                    }
                    case "LAMBDA_STORAGE": {
                        n = StateIdentifier.STATE_ID_LAMBDA_STORAGE.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "EntityIdService": {
                int n;
                switch (stateKey) {
                    case "ENTITY_ID": {
                        n = StateIdentifier.STATE_ID_ENTITY_ID.protoOrdinal();
                        break block20;
                    }
                    case "ENTITY_COUNTS": {
                        n = StateIdentifier.STATE_ID_ENTITY_COUNTS.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "FeeService": {
                int n;
                switch (stateKey) {
                    case "MIDNIGHT_RATES": {
                        n = StateIdentifier.STATE_ID_MIDNIGHT_RATES.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "FileService": {
                int n;
                if ("FILES".equals(stateKey)) {
                    n = StateIdentifier.STATE_ID_FILES.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(150))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_150.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(151))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_151.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(152))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_152.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(153))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_153.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(154))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_154.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(155))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_155.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(156))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_156.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(157))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_157.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(158))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_158.protoOrdinal();
                    break;
                }
                if (stateKey.matches(UPGRADE_DATA_FILE_FORMAT.apply(159))) {
                    n = StateIdentifier.STATE_ID_UPGRADE_DATA_159.protoOrdinal();
                    break;
                }
                n = -1;
                break;
            }
            case "FreezeService": {
                int n;
                switch (stateKey) {
                    case "FREEZE_TIME": {
                        n = StateIdentifier.STATE_ID_FREEZE_TIME.protoOrdinal();
                        break block20;
                    }
                    case "UPGRADE_FILE_HASH": {
                        n = StateIdentifier.STATE_ID_UPGRADE_FILE_HASH.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "PlatformStateService": {
                int n;
                switch (stateKey) {
                    case "PLATFORM_STATE": {
                        n = StateIdentifier.STATE_ID_PLATFORM_STATE.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "RecordCache": {
                int n;
                switch (stateKey) {
                    case "TransactionReceiptQueue": {
                        n = StateIdentifier.STATE_ID_TRANSACTION_RECEIPTS_QUEUE.protoOrdinal();
                        break block20;
                    }
                    case "TransactionRecordQueue": {
                        n = StateIdentifier.STATE_ID_TRANSACTION_RECEIPTS_QUEUE.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "RosterService": {
                int n;
                switch (stateKey) {
                    case "ROSTERS": {
                        n = StateIdentifier.STATE_ID_ROSTERS.protoOrdinal();
                        break block20;
                    }
                    case "ROSTER_STATE": {
                        n = StateIdentifier.STATE_ID_ROSTER_STATE.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "ScheduleService": {
                int n;
                switch (stateKey) {
                    case "SCHEDULES_BY_EQUALITY": {
                        n = StateIdentifier.STATE_ID_SCHEDULES_BY_EQUALITY.protoOrdinal();
                        break block20;
                    }
                    case "SCHEDULES_BY_EXPIRY_SEC": {
                        n = StateIdentifier.STATE_ID_SCHEDULES_BY_EXPIRY.protoOrdinal();
                        break block20;
                    }
                    case "SCHEDULES_BY_ID": {
                        n = StateIdentifier.STATE_ID_SCHEDULES_BY_ID.protoOrdinal();
                        break block20;
                    }
                    case "SCHEDULE_ID_BY_EQUALITY": {
                        n = StateIdentifier.STATE_ID_SCHEDULE_ID_BY_EQUALITY.protoOrdinal();
                        break block20;
                    }
                    case "SCHEDULED_COUNTS": {
                        n = StateIdentifier.STATE_ID_SCHEDULED_COUNTS.protoOrdinal();
                        break block20;
                    }
                    case "SCHEDULED_ORDERS": {
                        n = StateIdentifier.STATE_ID_SCHEDULED_ORDERS.protoOrdinal();
                        break block20;
                    }
                    case "SCHEDULED_USAGES": {
                        n = StateIdentifier.STATE_ID_SCHEDULED_USAGES.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "TokenService": {
                int n;
                switch (stateKey) {
                    case "ACCOUNTS": {
                        n = StateIdentifier.STATE_ID_ACCOUNTS.protoOrdinal();
                        break block20;
                    }
                    case "ALIASES": {
                        n = StateIdentifier.STATE_ID_ALIASES.protoOrdinal();
                        break block20;
                    }
                    case "NFTS": {
                        n = StateIdentifier.STATE_ID_NFTS.protoOrdinal();
                        break block20;
                    }
                    case "PENDING_AIRDROPS": {
                        n = StateIdentifier.STATE_ID_PENDING_AIRDROPS.protoOrdinal();
                        break block20;
                    }
                    case "STAKING_INFOS": {
                        n = StateIdentifier.STATE_ID_STAKING_INFO.protoOrdinal();
                        break block20;
                    }
                    case "STAKING_NETWORK_REWARDS": {
                        n = StateIdentifier.STATE_ID_NETWORK_REWARDS.protoOrdinal();
                        break block20;
                    }
                    case "TOKEN_RELS": {
                        n = StateIdentifier.STATE_ID_TOKEN_RELATIONS.protoOrdinal();
                        break block20;
                    }
                    case "TOKENS": {
                        n = StateIdentifier.STATE_ID_TOKENS.protoOrdinal();
                        break block20;
                    }
                    case "NODE_REWARDS": {
                        n = StateIdentifier.STATE_ID_NODE_REWARDS.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "TssBaseService": {
                int n;
                switch (stateKey) {
                    case "TSS_MESSAGES": {
                        n = StateIdentifier.STATE_ID_TSS_MESSAGES.protoOrdinal();
                        break block20;
                    }
                    case "TSS_VOTES": {
                        n = StateIdentifier.STATE_ID_TSS_VOTES.protoOrdinal();
                        break block20;
                    }
                    case "TSS_ENCRYPTION_KEYS": {
                        n = StateIdentifier.STATE_ID_TSS_ENCRYPTION_KEYS.protoOrdinal();
                        break block20;
                    }
                    case "TSS_STATUS": {
                        n = StateIdentifier.STATE_ID_TSS_STATUS.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "HintsService": {
                int n;
                switch (stateKey) {
                    case "HINTS_KEY_SETS": {
                        n = StateIdentifier.STATE_ID_HINTS_KEY_SETS.protoOrdinal();
                        break block20;
                    }
                    case "ACTIVE_HINT_CONSTRUCTION": {
                        n = StateIdentifier.STATE_ID_ACTIVE_HINTS_CONSTRUCTION.protoOrdinal();
                        break block20;
                    }
                    case "NEXT_HINT_CONSTRUCTION": {
                        n = StateIdentifier.STATE_ID_NEXT_HINTS_CONSTRUCTION.protoOrdinal();
                        break block20;
                    }
                    case "PREPROCESSING_VOTES": {
                        n = StateIdentifier.STATE_ID_PREPROCESSING_VOTES.protoOrdinal();
                        break block20;
                    }
                    case "CRS_STATE": {
                        n = StateIdentifier.STATE_ID_CRS_STATE.protoOrdinal();
                        break block20;
                    }
                    case "CRS_PUBLICATIONS": {
                        n = StateIdentifier.STATE_ID_CRS_PUBLICATIONS.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            case "HistoryService": {
                int n;
                switch (stateKey) {
                    case "LEDGER_ID": {
                        n = StateIdentifier.STATE_ID_LEDGER_ID.protoOrdinal();
                        break block20;
                    }
                    case "PROOF_KEY_SETS": {
                        n = StateIdentifier.STATE_ID_PROOF_KEY_SETS.protoOrdinal();
                        break block20;
                    }
                    case "ACTIVE_PROOF_CONSTRUCTION": {
                        n = StateIdentifier.STATE_ID_ACTIVE_PROOF_CONSTRUCTION.protoOrdinal();
                        break block20;
                    }
                    case "NEXT_PROOF_CONSTRUCTION": {
                        n = StateIdentifier.STATE_ID_NEXT_PROOF_CONSTRUCTION.protoOrdinal();
                        break block20;
                    }
                    case "HISTORY_SIGNATURES": {
                        n = StateIdentifier.STATE_ID_HISTORY_SIGNATURES.protoOrdinal();
                        break block20;
                    }
                    case "PROOF_VOTES": {
                        n = StateIdentifier.STATE_ID_PROOF_VOTES.protoOrdinal();
                        break block20;
                    }
                }
                n = -1;
                break;
            }
            default: {
                int n = stateId = -1;
            }
        }
        if (stateId == -1) {
            throw new IllegalArgumentException("Unknown state '" + serviceName + "." + stateKey + "'");
        }
        return stateId;
    }

    private static int getValidatedStateId(@NonNull String serviceName, @NonNull String stateKey) {
        int stateId = StateUtils.stateIdFor(serviceName, stateKey);
        if (stateId < 0 || stateId > 65535) {
            throw new IllegalArgumentException("State ID " + stateId + " must fit in [0..65535]");
        }
        return stateId;
    }

    public static String computeLabel(@NonNull String serviceName, @NonNull String stateKey) {
        String key = Objects.requireNonNull(serviceName) + "." + Objects.requireNonNull(stateKey);
        return LABEL_CACHE.computeIfAbsent(key, k -> k);
    }

    public static Pair<String, String> decomposeLabel(String label) {
        Objects.requireNonNull(label, "Label must not be null");
        int delimiterIndex = label.indexOf(46);
        if (delimiterIndex < 0) {
            throw new IllegalArgumentException("Label must be in the format 'serviceName.stateKey'");
        }
        String serviceName = label.substring(0, delimiterIndex);
        String stateKey = label.substring(delimiterIndex + 1);
        return Pair.of((Object)serviceName, (Object)stateKey);
    }

    public static Bytes getStateKeyForSingleton(@NonNull String serviceName, @NonNull String stateKey) {
        int stateId = StateUtils.getValidatedStateId(serviceName, stateKey);
        Bytes key = VIRTUAL_MAP_KEY_CACHE[stateId];
        if (key == null) {
            StateUtils.VIRTUAL_MAP_KEY_CACHE[stateId] = key = StateKey.PROTOBUF.toBytes((Object)new StateKey(new OneOf((Enum)StateKey.KeyOneOfType.SINGLETON, (Object)SingletonType.fromProtobufOrdinal((int)stateId))));
        }
        return key;
    }

    public static Bytes getStateKeyForQueue(@NonNull String serviceName, @NonNull String stateKey, long index) {
        return StateKey.PROTOBUF.toBytes((Object)new StateKey(new OneOf((Enum)StateKey.KeyOneOfType.fromProtobufOrdinal((int)StateUtils.getValidatedStateId(serviceName, stateKey)), (Object)index)));
    }

    public static <K> Bytes getStateKeyForKv(@NonNull String serviceName, @NonNull String stateKey, K key) {
        return StateKey.PROTOBUF.toBytes((Object)new StateKey(new OneOf((Enum)StateKey.KeyOneOfType.fromProtobufOrdinal((int)StateUtils.getValidatedStateId(serviceName, stateKey)), key)));
    }

    public static <V> StateValue getStateValue(@NonNull String serviceName, @NonNull String stateKey, V value) {
        return new StateValue(new OneOf((Enum)StateValue.ValueOneOfType.fromProtobufOrdinal((int)StateUtils.getValidatedStateId(serviceName, stateKey)), value));
    }

    public static StateValue getQueueStateValue(@NonNull QueueState queueState) {
        return new StateValue(new OneOf((Enum)StateValue.ValueOneOfType.QUEUE_STATE, (Object)queueState));
    }

    public static Bytes getStateKeyValueBytes(@NonNull String serviceName, @NonNull String stateKey, @NonNull Bytes objectBytes) {
        int stateId = StateUtils.getValidatedStateId(serviceName, stateKey);
        int tag = stateId << 3 | ProtoConstants.WIRE_TYPE_DELIMITED.ordinal();
        int length = Math.toIntExact(objectBytes.length());
        ByteBuffer byteBuffer = ByteBuffer.allocate(ProtoWriterTools.sizeOfVarInt32((int)tag) + ProtoWriterTools.sizeOfVarInt32((int)length) + length);
        BufferedData bufferedData = BufferedData.wrap((ByteBuffer)byteBuffer);
        bufferedData.writeVarInt(tag, false);
        bufferedData.writeVarInt(length, false);
        bufferedData.writeBytes((RandomAccessData)objectBytes);
        return Bytes.wrap((byte[])byteBuffer.array());
    }

    public static int extractStateKeyValueStateId(@NonNull Bytes objectBytes) {
        Objects.requireNonNull(objectBytes, "objectBytes must not be null");
        return ProtoParserTools.readNextFieldNumber((ReadableSequentialData)objectBytes.toReadableSequentialData());
    }
}

