/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.tipset;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.event.creator.impl.tipset.TipsetAdvancementWeight;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class Tipset {
    private final Roster roster;
    private final long[] tips;

    public Tipset(@NonNull Roster roster) {
        this.roster = Objects.requireNonNull(roster);
        this.tips = new long[roster.rosterEntries().size()];
        Arrays.fill(this.tips, 0L);
    }

    @NonNull
    private static Tipset buildEmptyTipset(@NonNull Tipset tipset) {
        return new Tipset(tipset.roster);
    }

    @NonNull
    public Tipset merge(@NonNull List<Tipset> tipsets) {
        if (tipsets.isEmpty()) {
            return new Tipset(this.roster);
        }
        int length = this.tips.length;
        Tipset newTipset = Tipset.buildEmptyTipset(this);
        for (int index = 0; index < length; ++index) {
            long max = this.tips[index];
            for (Tipset tipSet : tipsets) {
                max = Math.max(max, tipSet.tips[index]);
            }
            newTipset.tips[index] = max;
        }
        return newTipset;
    }

    public long getTipGenerationForNode(@NonNull NodeId nodeId) {
        int index = RosterUtils.getIndex((Roster)this.roster, (long)nodeId.id());
        if (index == -1) {
            return 0L;
        }
        return this.tips[index];
    }

    public int size() {
        return this.tips.length;
    }

    @NonNull
    public Tipset advance(@NonNull NodeId creator, long generation) {
        int index = RosterUtils.getIndex((Roster)this.roster, (long)creator.id());
        this.tips[index] = Math.max(this.tips[index], generation);
        return this;
    }

    @NonNull
    public TipsetAdvancementWeight getTipAdvancementWeight(@NonNull NodeId selfId, @NonNull Tipset that) {
        long nonZeroWeight = 0L;
        long zeroWeightCount = 0L;
        int selfIndex = RosterUtils.getIndex((Roster)this.roster, (long)selfId.id());
        for (int index = 0; index < this.tips.length; ++index) {
            if (index == selfIndex || this.tips[index] >= that.tips[index]) continue;
            RosterEntry address = (RosterEntry)this.roster.rosterEntries().get(index);
            if (address.weight() == 0L) {
                ++zeroWeightCount;
                continue;
            }
            nonZeroWeight += address.weight();
        }
        return TipsetAdvancementWeight.of(nonZeroWeight, zeroWeightCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int index = 0; index < this.tips.length; ++index) {
            sb.append(((RosterEntry)this.roster.rosterEntries().get(index)).nodeId()).append(":").append(this.tips[index]);
            if (index >= this.tips.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Tipset)) {
            return false;
        }
        Tipset tipset = (Tipset)o;
        return this.roster.equals((Object)tipset.roster) && Arrays.equals(this.tips, tipset.tips);
    }

    public int hashCode() {
        int result = this.roster.hashCode();
        result = 31 * result + Arrays.hashCode(this.tips);
        return result;
    }
}

