/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.transaction.pool;

import com.swirlds.demo.platform.HotspotConfiguration;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateSmartContract;
import com.swirlds.demo.platform.fs.stresstest.proto.SmartContractMethodExecution;
import com.swirlds.demo.platform.fs.stresstest.proto.VirtualMerkleTransaction;
import com.swirlds.demo.virtualmerkle.config.SmartContractConfig;
import com.swirlds.demo.virtualmerkle.random.PTTRandom;

public class SmartContractTransactionFactory {
    private static final int SIZE_AFTER_PADDING = 100;
    private final PTTRandom random;
    private final SmartContractConfig smartContractConfig;
    private final long firstSmartContractId;
    private int smartContractsCreated;

    public SmartContractTransactionFactory(PTTRandom random, long nodeId, long smartContractsPerNode, SmartContractConfig smartContractConfig, long firstSmartContractId) {
        this.random = random;
        this.firstSmartContractId = firstSmartContractId + nodeId * smartContractsPerNode;
        this.smartContractsCreated = 0;
        this.smartContractConfig = smartContractConfig;
    }

    public VirtualMerkleTransaction.Builder buildCreateSmartContractTransaction() {
        CreateSmartContract smartContract = CreateSmartContract.newBuilder().setContractId(this.generateNewContractId()).setTotalValuePairs(this.getTotalValuePairs()).setByteCodeSize(this.getByteCodeSize()).setSeed(this.random.nextLong()).build();
        VirtualMerkleTransaction.Builder builder = VirtualMerkleTransaction.newBuilder().setSmartContract(smartContract).setSampled(false);
        return builder;
    }

    public VirtualMerkleTransaction.Builder buildMethodExecutionTransaction(HotspotConfiguration hotspot) {
        SmartContractMethodExecution methodExecution = SmartContractMethodExecution.newBuilder().setSeed(this.random.nextLong()).setContractId(this.getRandomContractToBeUpdated(hotspot)).setReads(this.smartContractConfig.getReadsDuringMethodExecution()).setWrites(this.smartContractConfig.getWritesDuringMethodExecution()).setAdds(this.smartContractConfig.getAddsDuringMethodExecution()).build();
        return VirtualMerkleTransaction.newBuilder().setMethodExecution(methodExecution).setSampled(false);
    }

    private int getByteCodeSize() {
        return this.random.nextInt(this.smartContractConfig.getMinByteCodeSize(), Math.min(this.smartContractConfig.getMaxByteCodeSize() + 1, 12000));
    }

    private long getTotalValuePairs() {
        return this.random.nextLong(this.smartContractConfig.getMinKeyValuePairsDuringCreation(), this.smartContractConfig.getMaxKeyValuePairsDuringCreation() + 1);
    }

    private long generateNewContractId() {
        return this.firstSmartContractId + (long)this.smartContractsCreated++;
    }

    private long getRandomContractToBeUpdated(HotspotConfiguration hotspot) {
        if (this.smartContractsCreated == 0) {
            return this.firstSmartContractId;
        }
        if (hotspot == null) {
            return this.random.nextLong(this.firstSmartContractId, this.firstSmartContractId + (long)this.smartContractsCreated);
        }
        long limit = this.firstSmartContractId + (long)hotspot.getSize();
        return this.random.nextLong(this.firstSmartContractId, limit);
    }

    public static int getSizeAfterPadding() {
        return 100;
    }
}

