/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.communication.multithreaded;

import com.google.common.annotations.VisibleForTesting;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionManager;

public class ReturnOnceConnectionManager
implements ConnectionManager {
    final Connection connection;
    private volatile boolean connectionReturned = false;

    public ReturnOnceConnectionManager(Connection connection) {
        this.connection = connection;
    }

    public Connection waitForConnection() throws InterruptedException {
        if (this.connectionReturned) {
            throw new InterruptedException();
        }
        this.connectionReturned = true;
        return this.connection;
    }

    @VisibleForTesting
    public Connection getConnection() {
        throw new IllegalStateException("unsupported");
    }

    public void newConnection(Connection connection) {
        throw new IllegalStateException("unsupported");
    }

    public boolean isOutbound() {
        return this.connection.isOutbound();
    }
}

