/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class FCTimestamp
extends PartialMerkleLeaf
implements MerkleLeaf {
    private static final long CLASS_ID = 8278528513169858309L;
    private long seconds;
    private int nano;

    public FCTimestamp() {
    }

    private FCTimestamp(long seconds, int nano) {
        this.seconds = seconds;
        this.nano = nano;
    }

    private FCTimestamp(FCTimestamp timestamp) {
        super((PartialMerkleLeaf)timestamp);
        this.seconds = timestamp.seconds;
        this.nano = timestamp.nano;
    }

    public FCTimestamp copy() {
        this.throwIfImmutable();
        return new FCTimestamp(this);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("Trying to serialize a deleted FCTimestamp");
        }
        out.writeLong(this.seconds);
        out.writeInt(this.nano);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.seconds = in.readLong();
        this.nano = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FCTimestamp)) {
            return false;
        }
        FCTimestamp that = (FCTimestamp)((Object)o);
        return this.seconds == that.seconds && this.nano == that.nano;
    }

    public int hashCode() {
        return Objects.hash(this.seconds, this.nano);
    }

    static FCTimestamp generateRandom(Random random) {
        long seconds = random.nextLong();
        int nano = random.nextInt();
        return new FCTimestamp(seconds, nano);
    }

    public long getClassId() {
        return 8278528513169858309L;
    }

    public int getVersion() {
        return 2;
    }

    public int getMinimumSupportedVersion() {
        return 2;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;

        private ClassVersion() {
        }
    }
}

