/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.benchmark;

import java.time.Duration;

public class BenchmarkStatistic {
    private long totalTimeNanoseconds;
    private long totalOperationCount;
    private long startTimeNanoseconds;
    private final Duration testDuration;
    private final String name;

    public BenchmarkStatistic(String name, Duration testDuration) {
        this.name = name;
        this.testDuration = testDuration;
    }

    public void start() {
        this.startTimeNanoseconds = System.nanoTime();
    }

    public void stop() {
        this.totalTimeNanoseconds += System.nanoTime() - this.startTimeNanoseconds;
        ++this.totalOperationCount;
    }

    public Duration getAverageLatency() {
        if (this.totalOperationCount == 0L) {
            return Duration.ofNanos(-1L);
        }
        return Duration.ofNanos(this.totalTimeNanoseconds / this.totalOperationCount);
    }

    public double getAverageThroughput() {
        return (double)this.totalOperationCount / (double)this.testDuration.toSeconds();
    }

    public long getCount() {
        return this.totalOperationCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(":\n");
        sb.append("    total number of operations: ").append(this.totalOperationCount).append("\n");
        sb.append("    latency: ").append(BenchmarkStatistic.humanReadableDuration(this.getAverageLatency())).append("\n");
        sb.append("    throughput: ").append(String.format("%.1f", this.getAverageThroughput())).append(" hz\n");
        return sb.toString();
    }

    private static String humanReadableDuration(Duration duration) {
        String unit = "ns";
        double value = duration.getNano();
        if (value > 1000.0) {
            value /= 1000.0;
            unit = "us";
        }
        if (value > 1000.0) {
            value /= 1000.0;
            unit = "ms";
        }
        if (value > 1000.0) {
            value /= 1000.0;
            unit = "s";
        }
        return String.format("%.1f %s", value, unit);
    }
}

