/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.internal.network.codec;

import com.hedera.node.internal.network.BlockNodeConfig;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class BlockNodeConfigJsonCodec
implements JsonCodec<BlockNodeConfig> {
    @NonNull
    public BlockNodeConfig parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            String temp_address = "";
            int temp_port = 0;
            int temp_priority = 0;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "address": {
                        temp_address = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                    case "port": {
                        temp_port = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                    case "priority": {
                        temp_priority = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new BlockNodeConfig(temp_address, temp_port, temp_priority);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull BlockNodeConfig data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.address() != "") {
            fieldLines.add(JsonTools.field((String)"address", (String)data.address()));
        }
        if (data.port() != 0) {
            fieldLines.add(JsonTools.field((String)"port", (int)data.port()));
        }
        if (data.priority() != 0) {
            fieldLines.add(JsonTools.field((String)"priority", (int)data.priority()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

