/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public record UnknownField(int field, @NonNull ProtoConstants wireType, @NonNull Bytes bytes) implements Comparable<UnknownField>
{
    @Override
    public int compareTo(UnknownField o) {
        return Integer.compare(this.field, o.field);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UnknownField)) {
            return false;
        }
        UnknownField that = (UnknownField)o;
        return this.field == that.field && this.wireType == that.wireType && Objects.equals(this.bytes, that.bytes);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Integer.hashCode(this.field);
        hashCode = 31 * hashCode + Integer.hashCode(this.wireType.ordinal());
        hashCode = 31 * hashCode + this.bytes.hashCode();
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return hashCode;
    }

    public int protobufCompareTo(UnknownField o) {
        int result = this.compareTo(o);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.wireType.ordinal(), o.wireType.ordinal());
        if (result != 0) {
            return result;
        }
        return this.bytes.compareTo(o.bytes);
    }

    public void printToString(StringBuilder sb) {
        sb.append(this.field).append("=");
        switch (this.wireType) {
            case WIRE_TYPE_VARINT_OR_ZIGZAG: {
                sb.append(this.bytes.getVarLong(0L, false));
                break;
            }
            case WIRE_TYPE_FIXED_32_BIT: {
                sb.append(this.bytes.getInt(0L));
                break;
            }
            case WIRE_TYPE_FIXED_64_BIT: {
                sb.append(this.bytes.getLong(0L));
                break;
            }
            case WIRE_TYPE_DELIMITED: {
                sb.append('[').append(this.bytes.toString()).append(']');
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported wire type: " + String.valueOf((Object)this.wireType));
            }
        }
    }
}

