/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.collections;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.collections.AbstractLongList;
import com.swirlds.merkledb.collections.OffHeapUser;
import com.swirlds.merkledb.utilities.MerkleDbFileUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.MemoryUtils;

public final class LongListOffHeap
extends AbstractLongList<ByteBuffer>
implements OffHeapUser {
    private static final Logger logger = LogManager.getLogger(LongListOffHeap.class);

    public LongListOffHeap(long capacity, Configuration configuration) {
        super(capacity, configuration);
    }

    public LongListOffHeap(int longsPerChunk, long capacity, long reservedBufferSize) {
        super(longsPerChunk, capacity, reservedBufferSize);
    }

    public LongListOffHeap(@NonNull Path file, long capacity, @NonNull Configuration configuration) throws IOException {
        super(file, capacity, configuration);
    }

    public LongListOffHeap(@NonNull Path path, int longsPerChunk, long capacity, long reservedBufferSize, @NonNull Configuration configuration) throws IOException {
        super(path, longsPerChunk, capacity, reservedBufferSize, configuration);
    }

    @Override
    protected ByteBuffer readChunkData(FileChannel fileChannel, int chunkIndex, int startIndex, int endIndex) throws IOException {
        ByteBuffer chunk = this.createChunk();
        LongListOffHeap.readDataIntoBuffer(fileChannel, chunkIndex, startIndex, endIndex, chunk);
        chunk.clear();
        return chunk;
    }

    @Override
    protected void closeChunk(@NonNull ByteBuffer directBuffer) {
        MemoryUtils.closeDirectByteBuffer((ByteBuffer)directBuffer);
    }

    @Override
    protected void putToChunk(ByteBuffer chunk, int subIndex, long value) {
        int subIndexOffset = subIndex * 8;
        MemoryUtils.putLongVolatile((ByteBuffer)chunk, (long)subIndexOffset, (long)value);
    }

    @Override
    protected boolean putIfEqual(ByteBuffer chunk, int subIndex, long oldValue, long newValue) {
        int subIndexBytes = subIndex * 8;
        return MemoryUtils.compareAndSwapLong((ByteBuffer)chunk, (long)subIndexBytes, (long)oldValue, (long)newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeLongsData(FileChannel fc) throws IOException {
        int totalNumOfChunks = this.calculateNumberOfChunks(this.size());
        long currentMinValidIndex = this.minValidIndex.get();
        int firstChunkWithDataIndex = Math.toIntExact(currentMinValidIndex / (long)this.longsPerChunk);
        ByteBuffer emptyBuffer = this.createChunk();
        try {
            for (int i = firstChunkWithDataIndex; i < totalNumOfChunks; ++i) {
                ByteBuffer byteBuffer = (ByteBuffer)this.chunkList.get(i);
                ByteBuffer nonNullBuffer = Objects.requireNonNullElse(byteBuffer, emptyBuffer);
                ByteBuffer buf = nonNullBuffer.slice(0, nonNullBuffer.limit());
                if (i == firstChunkWithDataIndex) {
                    int firstValidIndexInChunk = Math.toIntExact(currentMinValidIndex % (long)this.longsPerChunk);
                    buf.position(firstValidIndexInChunk * 8);
                } else {
                    buf.position(0);
                }
                if (i == totalNumOfChunks - 1) {
                    long bytesWrittenSoFar = (long)this.memoryChunkSize * (long)i;
                    long remainingBytes = this.size() * 8L - bytesWrittenSoFar;
                    buf.limit(Math.toIntExact(remainingBytes));
                } else {
                    buf.limit(buf.capacity());
                }
                MerkleDbFileUtils.completelyWrite(fc, buf);
            }
        }
        finally {
            MemoryUtils.closeDirectByteBuffer((ByteBuffer)emptyBuffer);
        }
    }

    @Override
    protected long lookupInChunk(@NonNull ByteBuffer chunk, long subIndex) {
        try {
            return MemoryUtils.getLongVolatile((ByteBuffer)chunk, (long)(subIndex * 8L));
        }
        catch (IndexOutOfBoundsException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Index out of bounds in lookupInChunk: buf={}, offset={}, subIndex={}", (Object)chunk, (Object)subIndex, (Object)e);
            throw e;
        }
    }

    @Override
    protected ByteBuffer createChunk() {
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(this.memoryChunkSize);
        directBuffer.order(ByteOrder.nativeOrder());
        return directBuffer;
    }

    @Override
    protected void partialChunkCleanup(@NonNull ByteBuffer chunk, boolean leftSide, long entriesToCleanUp) {
        if (leftSide) {
            MemoryUtils.setMemory((ByteBuffer)chunk, (long)0L, (long)(entriesToCleanUp * 8L), (byte)0);
        } else {
            long offset = ((long)this.longsPerChunk - entriesToCleanUp) * 8L;
            MemoryUtils.setMemory((ByteBuffer)chunk, (long)offset, (long)(entriesToCleanUp * 8L), (byte)0);
        }
    }

    @Override
    public long getOffHeapConsumption() {
        int nonEmptyChunkCount = 0;
        int chunkListSize = this.chunkList.length();
        for (int i = 0; i < chunkListSize; ++i) {
            if (this.chunkList.get(i) == null) continue;
            ++nonEmptyChunkCount;
        }
        return (long)nonEmptyChunkCount * (long)this.memoryChunkSize;
    }
}

